/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractChecker;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/dataFlow/ContractInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                for (MethodContract contract : ControlFlowAnalyzer.getMethodContracts(method)) {
                    Map<PsiElement, String> errors = ContractChecker.checkContractClause(method, contract, false, isOnTheFly);
                    for (Map.Entry<PsiElement, String> entry : errors.entrySet()) {
                        PsiElement element = entry.getKey();
                        holder.registerProblem(element, entry.getValue(), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                String error;
                if (!ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
                if (method == null) {
                    return;
                }
                String text = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                if (StringUtil.isNotEmpty((String)text) && (error = ContractInspection.checkContract(method, text)) != null) {
                    PsiAnnotationMemberValue value = annotation.findAttributeValue(null);
                    assert (value != null);
                    holder.registerProblem((PsiElement)value, error, new LocalQuickFix[0]);
                    return;
                }
                if (Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure")) && PsiType.VOID.equals((Object)method.getReturnType())) {
                    PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("pure");
                    assert (value != null);
                    holder.registerProblem((PsiElement)value, "Pure methods must return something, void is not allowed as a return type", new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    public static String checkContract(PsiMethod method, String text) {
        List<MethodContract> contracts;
        try {
            contracts = MethodContract.parseContract(text);
        }
        catch (MethodContract.ParseException e) {
            return e.getMessage();
        }
        int paramCount = method.getParameterList().getParametersCount();
        for (int i = 0; i < contracts.size(); ++i) {
            MethodContract contract = contracts.get(i);
            if (contract.arguments.length != paramCount) {
                return "Method takes " + paramCount + " parameters, while contract clause number " + (i + 1) + " expects " + contract.arguments.length;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null || ContractInspection.isReturnTypeCompatible(returnType, contract.returnValue)) continue;
            return "Method returns " + returnType.getPresentableText() + " but the contract specifies " + (Object)((Object)contract.returnValue);
        }
        return null;
    }

    static boolean isReturnTypeCompatible(@Nullable PsiType returnType, @NotNull MethodContract.ValueConstraint returnValue) {
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "com/intellij/codeInspection/dataFlow/ContractInspection", "isReturnTypeCompatible"));
        }
        if (returnValue == MethodContract.ValueConstraint.ANY_VALUE || returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
            return true;
        }
        if (PsiType.VOID.equals((Object)returnType)) {
            return false;
        }
        if (PsiType.BOOLEAN.equals((Object)returnType)) {
            return returnValue == MethodContract.ValueConstraint.TRUE_VALUE || returnValue == MethodContract.ValueConstraint.FALSE_VALUE;
        }
        if (returnType instanceof PsiClassType) {
            return returnValue == MethodContract.ValueConstraint.NULL_VALUE || returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        return true;
    }
}

