/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import gnu.trove.TIntArrayList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildArtifactAction
extends DumbAwareAction {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Clean artifact");

    public BuildArtifactAction() {
        super("Build Artifacts...", "Select and build artifacts configured in the project", null);
    }

    public void update(AnActionEvent e) {
        Project project = BuildArtifactAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project != null && !ArtifactUtil.getArtifactWithOutputPaths(project).isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = BuildArtifactAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        List<Artifact> artifacts = ArtifactUtil.getArtifactWithOutputPaths(project);
        if (artifacts.isEmpty()) {
            return;
        }
        ArrayList<ArtifactPopupItem> items = new ArrayList<ArtifactPopupItem>();
        if (artifacts.size() > 1) {
            items.add(0, new ArtifactPopupItem(null, "All Artifacts", EmptyIcon.ICON_16));
        }
        HashSet<Artifact> selectedArtifacts = new HashSet<Artifact>(ArtifactsWorkspaceSettings.getInstance(project).getArtifactsToBuild());
        TIntArrayList selectedIndices = new TIntArrayList();
        if (Comparing.haveEqualElements(artifacts, selectedArtifacts) && selectedArtifacts.size() > 1) {
            selectedIndices.add(0);
            selectedArtifacts.clear();
        }
        for (Artifact artifact : artifacts) {
            ArtifactPopupItem item = new ArtifactPopupItem(artifact, artifact.getName(), artifact.getArtifactType().getIcon());
            if (selectedArtifacts.contains(artifact)) {
                selectedIndices.add(items.size());
            }
            items.add(item);
        }
        ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance(project);
        final ArtifactAwareProjectSettingsService settingsService = projectSettingsService instanceof ArtifactAwareProjectSettingsService ? (ArtifactAwareProjectSettingsService)((Object)projectSettingsService) : null;
        ChooseArtifactStep step = new ChooseArtifactStep(items, artifacts.get(0), project, settingsService);
        step.setDefaultOptionIndices(selectedIndices.toNativeArray());
        final ListPopupImpl popup = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        KeyStroke editKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource());
        if (settingsService != null && editKeyStroke != null) {
            popup.registerAction("editArtifact", editKeyStroke, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] values = popup.getSelectedValues();
                    popup.cancel();
                    settingsService.openArtifactSettings(values.length > 0 ? ((ArtifactPopupItem)values[0]).getArtifact() : null);
                }
            });
        }
        popup.showCenteredInCurrentWindow(project);
    }

    private static void doBuild(@NotNull Project project, @NotNull List<ArtifactPopupItem> items, boolean rebuild) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/actions/BuildArtifactAction", "doBuild"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/compiler/actions/BuildArtifactAction", "doBuild"));
        }
        Set<Artifact> artifacts = BuildArtifactAction.getArtifacts(items, project);
        CompileScope scope = ArtifactCompileScope.createArtifactsScope(project, artifacts, rebuild);
        ArtifactsWorkspaceSettings.getInstance(project).setArtifactsToBuild(artifacts);
        CompilerManager.getInstance((Project)project).make(scope, null);
    }

    private static Set<Artifact> getArtifacts(List<ArtifactPopupItem> items, Project project) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (ArtifactPopupItem item : items) {
            artifacts.addAll(item.getArtifacts(project));
        }
        return artifacts;
    }

    private static class ChooseArtifactStep
    extends MultiSelectionListPopupStep<ArtifactPopupItem> {
        private final Artifact myFirst;
        private final Project myProject;
        private ArtifactAwareProjectSettingsService mySettingsService;

        public ChooseArtifactStep(List<ArtifactPopupItem> artifacts, Artifact first, Project project, ArtifactAwareProjectSettingsService settingsService) {
            super("Build Artifact", artifacts);
            this.myFirst = first;
            this.myProject = project;
            this.mySettingsService = settingsService;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public Icon getIconFor(ArtifactPopupItem aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ArtifactPopupItem value) {
            String string = value.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/actions/BuildArtifactAction$ChooseArtifactStep", "getTextFor"));
            }
            return string;
        }

        @Override
        public boolean hasSubstep(List<ArtifactPopupItem> selectedValues) {
            return true;
        }

        public ListSeparator getSeparatorAbove(ArtifactPopupItem value) {
            return this.myFirst.equals(value.getArtifact()) ? new ListSeparator() : null;
        }

        @Override
        public PopupStep<?> onChosen(final List<ArtifactPopupItem> selectedValues, boolean finalChoice) {
            if (finalChoice) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BuildArtifactAction.doBuild(ChooseArtifactStep.this.myProject, selectedValues, false);
                    }
                });
            }
            ArrayList<ArtifactActionItem> actions = new ArrayList<ArtifactActionItem>();
            actions.add(new BuildArtifactItem((List)selectedValues, this.myProject));
            actions.add(new RebuildArtifactItem((List)selectedValues, this.myProject));
            actions.add(new CleanArtifactItem((List)selectedValues, this.myProject));
            if (this.mySettingsService != null) {
                actions.add(new EditArtifactItem(selectedValues, this.myProject, this.mySettingsService));
            }
            return new BaseListPopupStep<ArtifactActionItem>(selectedValues.size() == 1 ? "Action" : "Action for " + selectedValues.size() + " artifacts", actions){

                @NotNull
                public String getTextFor(ArtifactActionItem value) {
                    String string = value.getActionName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/actions/BuildArtifactAction$ChooseArtifactStep$2", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(ArtifactActionItem selectedValue, boolean finalChoice) {
                    return this.doFinalStep(selectedValue);
                }
            };
        }
    }

    private static class ArtifactPopupItem {
        @Nullable
        private final Artifact myArtifact;
        private final String myText;
        private final Icon myIcon;

        private ArtifactPopupItem(@Nullable Artifact artifact, String text, Icon icon) {
            this.myArtifact = artifact;
            this.myText = text;
            this.myIcon = icon;
        }

        @Nullable
        public Artifact getArtifact() {
            return this.myArtifact;
        }

        public String getText() {
            return this.myText;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public List<Artifact> getArtifacts(Project project) {
            Artifact artifact = this.getArtifact();
            return artifact != null ? Collections.singletonList(artifact) : ArtifactUtil.getArtifactWithOutputPaths(project);
        }
    }

    private static abstract class ArtifactActionItem
    implements Runnable {
        protected final List<ArtifactPopupItem> myArtifactPopupItems;
        protected final Project myProject;
        private String myActionName;

        protected ArtifactActionItem(@NotNull List<ArtifactPopupItem> item, @NotNull Project project, @NotNull String name) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/compiler/actions/BuildArtifactAction$ArtifactActionItem", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/actions/BuildArtifactAction$ArtifactActionItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/compiler/actions/BuildArtifactAction$ArtifactActionItem", "<init>"));
            }
            this.myArtifactPopupItems = item;
            this.myProject = project;
            this.myActionName = name;
        }

        public String getActionName() {
            return this.myActionName;
        }
    }

    private static class EditArtifactItem
    extends ArtifactActionItem {
        private final ArtifactAwareProjectSettingsService mySettingsService;

        private EditArtifactItem(List<ArtifactPopupItem> item, Project project, ArtifactAwareProjectSettingsService projectSettingsService) {
            super(item, project, "Edit...");
            this.mySettingsService = projectSettingsService;
        }

        @Override
        public void run() {
            this.mySettingsService.openArtifactSettings(((ArtifactPopupItem)this.myArtifactPopupItems.get(0)).getArtifact());
        }
    }

    private static class RebuildArtifactItem
    extends ArtifactActionItem {
        private RebuildArtifactItem(List<ArtifactPopupItem> item, Project project) {
            super(item, project, "Rebuild");
        }

        @Override
        public void run() {
            BuildArtifactAction.doBuild(this.myProject, this.myArtifactPopupItems, true);
        }
    }

    private static class CleanArtifactItem
    extends ArtifactActionItem {
        private CleanArtifactItem(@NotNull List<ArtifactPopupItem> item, @NotNull Project project) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/compiler/actions/BuildArtifactAction$CleanArtifactItem", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/actions/BuildArtifactAction$CleanArtifactItem", "<init>"));
            }
            super(item, project, "Clean");
        }

        @Override
        public void run() {
            VirtualFile[] roots;
            HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
            VirtualFile[] arr$ = roots = ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                VirtualFile root;
                for (VirtualFile parent = root = arr$[i$]; parent != null && !parents.contains(parent); parent = parent.getParent()) {
                    parents.add(parent);
                }
            }
            HashMap<String, String> outputPathContainingSourceRoots = new HashMap<String, String>();
            final ArrayList<Pair> toClean = new ArrayList<Pair>();
            Set artifacts = BuildArtifactAction.getArtifacts(this.myArtifactPopupItems, this.myProject);
            for (Artifact artifact : artifacts) {
                String outputPath = artifact.getOutputFilePath();
                if (outputPath == null) continue;
                toClean.add(Pair.create((Object)new File(FileUtil.toSystemDependentName((String)outputPath)), (Object)artifact));
                VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
                if (!parents.contains(outputFile)) continue;
                outputPathContainingSourceRoots.put(artifact.getName(), outputPath);
            }
            if (!outputPathContainingSourceRoots.isEmpty()) {
                String message;
                if (outputPathContainingSourceRoots.size() == 1 && outputPathContainingSourceRoots.values().size() == 1) {
                    String name = (String)ContainerUtil.getFirstItem(outputPathContainingSourceRoots.keySet());
                    String output = (String)outputPathContainingSourceRoots.get(name);
                    message = "The output directory '" + output + "' of '" + name + "' artifact contains source roots of the project. Do you want to continue and clear it?";
                } else {
                    StringBuilder info = new StringBuilder();
                    for (String name : outputPathContainingSourceRoots.keySet()) {
                        info.append(" '").append(name).append("' artifact ('").append((String)outputPathContainingSourceRoots.get(name)).append("')\n");
                    }
                    message = "The output directories of the following artifacts contains source roots:\n" + info + "Do you want to continue and clear these directories?";
                }
                int answer = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)"Clean Artifacts", null);
                if (answer != 0) {
                    return;
                }
            }
            new Task.Backgroundable(this.myProject, "Cleaning artifacts...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/compiler/actions/BuildArtifactAction$CleanArtifactItem$1", "run"));
                    }
                    ArrayList<File> deleted = new ArrayList<File>();
                    for (Pair pair : toClean) {
                        indicator.checkCanceled();
                        File file = (File)pair.getFirst();
                        if (!FileUtil.delete((File)file)) {
                            NOTIFICATION_GROUP.createNotification("Cannot clean '" + ((Artifact)pair.getSecond()).getName() + "' artifact", "cannot delete '" + file.getAbsolutePath() + "'", NotificationType.ERROR, null).notify(this.myProject);
                            continue;
                        }
                        deleted.add(file);
                    }
                    LocalFileSystem.getInstance().refreshIoFiles(deleted, true, true, null);
                }
            }.queue();
        }
    }

    private static class BuildArtifactItem
    extends ArtifactActionItem {
        private BuildArtifactItem(List<ArtifactPopupItem> item, Project project) {
            super(item, project, "Build");
        }

        @Override
        public void run() {
            BuildArtifactAction.doBuild(this.myProject, this.myArtifactPopupItems, false);
        }
    }
}

