/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.LambdaSmartStepTarget;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class PsiMethodListPopupStep
implements ListPopupStep<SmartStepTarget> {
    private final List<SmartStepTarget> myTargets;
    private final OnChooseRunnable myStepRunnable;
    private final ScopeHighlighter myScopeHighlighter;

    public PsiMethodListPopupStep(Editor editor, List<SmartStepTarget> targets, OnChooseRunnable stepRunnable) {
        this.myTargets = targets;
        this.myScopeHighlighter = new ScopeHighlighter(editor);
        this.myStepRunnable = stepRunnable;
    }

    @NotNull
    public ScopeHighlighter getScopeHighlighter() {
        ScopeHighlighter scopeHighlighter = this.myScopeHighlighter;
        if (scopeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PsiMethodListPopupStep", "getScopeHighlighter"));
        }
        return scopeHighlighter;
    }

    @NotNull
    public List<SmartStepTarget> getValues() {
        List<SmartStepTarget> list = this.myTargets;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PsiMethodListPopupStep", "getValues"));
        }
        return list;
    }

    public boolean isSelectable(SmartStepTarget value) {
        return true;
    }

    public Icon getIconFor(SmartStepTarget aValue) {
        if (aValue instanceof MethodSmartStepTarget) {
            return ((MethodSmartStepTarget)aValue).getMethod().getIcon(0);
        }
        if (aValue instanceof LambdaSmartStepTarget) {
            return AllIcons.Nodes.Function;
        }
        return null;
    }

    @NotNull
    public String getTextFor(SmartStepTarget value) {
        String formatted;
        String label = value.getLabel();
        if (value instanceof MethodSmartStepTarget) {
            PsiMethod method = ((MethodSmartStepTarget)value).getMethod();
            formatted = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2, (int)999);
        } else if (value instanceof LambdaSmartStepTarget) {
            PsiLambdaExpression lambda = ((LambdaSmartStepTarget)value).getLambda();
            formatted = PsiFormatUtil.formatType((PsiType)lambda.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        } else {
            formatted = "";
        }
        String string = label != null ? label + formatted : formatted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PsiMethodListPopupStep", "getTextFor"));
        }
        return string;
    }

    public ListSeparator getSeparatorAbove(SmartStepTarget value) {
        return null;
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public String getTitle() {
        return DebuggerBundle.message((String)"title.smart.step.popup", (Object[])new Object[0]);
    }

    public PopupStep onChosen(SmartStepTarget selectedValue, boolean finalChoice) {
        if (finalChoice) {
            this.myScopeHighlighter.dropHighlight();
            this.myStepRunnable.execute(selectedValue);
        }
        return FINAL_CHOICE;
    }

    public Runnable getFinalRunnable() {
        return null;
    }

    public boolean hasSubstep(SmartStepTarget selectedValue) {
        return false;
    }

    public void canceled() {
        this.myScopeHighlighter.dropHighlight();
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return false;
    }

    public SpeedSearchFilter getSpeedSearchFilter() {
        return null;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public static interface OnChooseRunnable {
        public void execute(SmartStepTarget var1);
    }
}

