/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Developer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.http.client.fluent.Request;

class DevelopersLoader {
    private static final String DEVELOPERS_LIST_URL = "http://ea-engine.labs.intellij.net/data?category=developers";
    public static final int TIMEOUT = 1000;

    private DevelopersLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Developer> fetchDevelopers(ProgressIndicator indicator) throws IOException {
        LinkedList<Developer> developers = new LinkedList<Developer>();
        developers.add(Developer.NULL);
        BufferedReader reader = new BufferedReader(new InputStreamReader(Request.Get((String)DEVELOPERS_LIST_URL).connectTimeout(1000).execute().returnContent().asStream(), CharsetToolkit.UTF8_CHARSET));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(9);
                if (i == -1) {
                    throw new IOException("Protocol error");
                }
                int id = Integer.parseInt(line.substring(0, i));
                String name = line.substring(i + 1);
                developers.add(new Developer(id, name));
                indicator.checkCanceled();
            }
            LinkedList<Developer> linkedList = developers;
            return linkedList;
        }
        finally {
            reader.close();
        }
    }
}

