/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultCreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTSetDirective;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.FileTemplateUtil");
    private static final CreateFromTemplateHandler ourDefaultCreateFromTemplateHandler = new DefaultCreateFromTemplateHandler();
    @NonNls
    public static final String INTERNAL_PACKAGE_INFO_TEMPLATE_NAME = "package-info";

    private FileTemplateUtil() {
    }

    public static String[] calculateAttributes(String templateContent, Properties properties, boolean includeDummies) throws ParseException {
        HashSet<String> propertiesNames = new HashSet<String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            propertiesNames.add((String)e.nextElement());
        }
        return FileTemplateUtil.calculateAttributes(templateContent, propertiesNames, includeDummies);
    }

    public static String[] calculateAttributes(String templateContent, Map<String, Object> properties, boolean includeDummies) throws ParseException {
        return FileTemplateUtil.calculateAttributes(templateContent, properties.keySet(), includeDummies);
    }

    public static String[] calculateAttributes(String templateContent, Set<String> propertiesNames, boolean includeDummies) throws ParseException {
        LinkedHashSet<String> unsetAttributes = new LinkedHashSet<String>();
        HashSet<String> definedAttributes = new HashSet<String>();
        SimpleNode template = RuntimeSingleton.parse((Reader)new StringReader(templateContent), (String)"MyTemplate");
        FileTemplateUtil.collectAttributes(unsetAttributes, definedAttributes, (Node)template, propertiesNames, includeDummies, new HashSet<String>());
        for (String definedAttribute : definedAttributes) {
            unsetAttributes.remove(definedAttribute);
        }
        return ArrayUtil.toStringArray(unsetAttributes);
    }

    private static void collectAttributes(Set<String> referenced, Set<String> defined, Node apacheNode, Set<String> propertiesNames, boolean includeDummies, Set<String> visitedIncludes) throws ParseException {
        int childCount = apacheNode.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            Token firstToken;
            Node literal;
            Node apacheChild = apacheNode.jjtGetChild(i);
            FileTemplateUtil.collectAttributes(referenced, defined, apacheChild, propertiesNames, includeDummies, visitedIncludes);
            if (apacheChild instanceof ASTReference) {
                ASTReference apacheReference = (ASTReference)apacheChild;
                String s = apacheReference.literal();
                if ((s = FileTemplateUtil.referenceToAttribute(s, includeDummies)) == null || s.length() <= 0 || propertiesNames.contains(s)) continue;
                referenced.add(s);
                continue;
            }
            if (apacheChild instanceof ASTSetDirective) {
                ASTReference lhs = (ASTReference)apacheChild.jjtGetChild(0);
                String attr = FileTemplateUtil.referenceToAttribute(lhs.literal(), false);
                if (attr == null) continue;
                defined.add(attr);
                continue;
            }
            if (!(apacheChild instanceof ASTDirective) || !"parse".equals(((ASTDirective)apacheChild).getDirectiveName()) || apacheChild.jjtGetNumChildren() != 1 || !((literal = apacheChild.jjtGetChild(0)) instanceof ASTStringLiteral) || literal.jjtGetNumChildren() != 0 || (firstToken = literal.getFirstToken()) == null) continue;
            String s = StringUtil.unquoteString((String)firstToken.toString());
            FileTemplate includedTemplate = FileTemplateManager.getInstance().getTemplate(s);
            if (includedTemplate == null || !visitedIncludes.add(s)) continue;
            SimpleNode template = RuntimeSingleton.parse((Reader)new StringReader(includedTemplate.getText()), (String)"MyTemplate");
            FileTemplateUtil.collectAttributes(referenced, defined, (Node)template, propertiesNames, includeDummies, visitedIncludes);
        }
    }

    @Nullable
    private static String referenceToAttribute(String attrib, boolean includeDummies) {
        while (attrib.startsWith("\\\\")) {
            attrib = attrib.substring(2);
        }
        if (attrib.startsWith("\\$")) {
            if (includeDummies) {
                attrib = attrib.substring(1);
            } else {
                return null;
            }
        }
        if (!StringUtil.startsWithChar((CharSequence)attrib, (char)'$')) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)(attrib = attrib.substring(1)), (char)'{')) {
            String cleanAttribute = null;
            for (int i = 1; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar == '{' || currChar == '.') {
                    cleanAttribute = null;
                    break;
                }
                if (currChar != '}') continue;
                cleanAttribute = attrib.substring(1, i);
                break;
            }
            attrib = cleanAttribute;
        } else {
            for (int i = 0; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar != '{' && currChar != '}' && currChar != '.') continue;
                attrib = attrib.substring(0, i);
                break;
            }
        }
        return attrib;
    }

    public static String mergeTemplate(Map attributes, String content, boolean useSystemLineSeparators) throws IOException {
        VelocityContext context = FileTemplateUtil.createVelocityContext();
        for (Object o : attributes.keySet()) {
            String name = (String)o;
            context.put(name, attributes.get(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context, useSystemLineSeparators);
    }

    private static VelocityContext createVelocityContext() {
        VelocityContext context = new VelocityContext();
        context.put("StringUtils", StringUtils.class);
        return context;
    }

    public static String mergeTemplate(Properties attributes, String content, boolean useSystemLineSeparators) throws IOException {
        VelocityContext context = FileTemplateUtil.createVelocityContext();
        Enumeration<?> names = attributes.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            context.put(name, (Object)attributes.getProperty(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context, useSystemLineSeparators);
    }

    private static String mergeTemplate(String templateContent, VelocityContext context, boolean useSystemLineSeparators) throws IOException {
        String newSeparator;
        StringWriter stringWriter = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)stringWriter, (String)"", (String)templateContent);
        }
        catch (VelocityException e) {
            LOG.info("Error evaluating template:\n" + templateContent, (Throwable)e);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)IdeBundle.message((String)"error.parsing.file.template", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.velocity.error", (Object[])new Object[0]));
                }
            });
        }
        String result = stringWriter.toString();
        if (useSystemLineSeparators && !"\n".equals(newSeparator = CodeStyleSettingsManager.getSettings((Project)ProjectManagerEx.getInstanceEx().getDefaultProject()).getLineSeparator())) {
            return StringUtil.convertLineSeparators((String)result, (String)newSeparator);
        }
        return result;
    }

    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @NonNls @Nullable String fileName, @Nullable Properties props, @NotNull PsiDirectory directory) throws Exception {
        HashMap<String, Object> map;
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/fileTemplates/FileTemplateUtil", "createFromTemplate"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/fileTemplates/FileTemplateUtil", "createFromTemplate"));
        }
        if (props != null) {
            map = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map, props);
        } else {
            map = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName, map, directory, null);
    }

    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @NonNls @Nullable String fileName, @Nullable Properties props, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        HashMap<String, Object> map;
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/fileTemplates/FileTemplateUtil", "createFromTemplate"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/fileTemplates/FileTemplateUtil", "createFromTemplate"));
        }
        if (props != null) {
            map = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map, props);
        } else {
            map = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName, map, directory, classLoader);
    }

    public static PsiElement createFromTemplate(final @NotNull FileTemplate template, @NonNls @Nullable String fileName, @Nullable Map<String, Object> propsMap, final @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        String[] dummyRefs;
        Properties p;
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ide/fileTemplates/FileTemplateUtil", "createFromTemplate"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/fileTemplates/FileTemplateUtil", "createFromTemplate"));
        }
        final Project project = directory.getProject();
        if (propsMap == null) {
            p = FileTemplateManager.getInstance().getDefaultProperties(directory.getProject());
            propsMap = new HashMap<String, Object>();
            FileTemplateUtil.putAll(propsMap, p);
        }
        FileTemplateManager.getInstance().addRecentName(template.getName());
        p = new Properties();
        FileTemplateUtil.fillDefaultProperties(p, directory);
        FileTemplateUtil.putAll(propsMap, p);
        final CreateFromTemplateHandler handler = FileTemplateUtil.findHandler(template);
        if (fileName != null && propsMap.get("NAME") == null) {
            propsMap.put("NAME", fileName);
        } else if (fileName == null && handler.isNameRequired() && (fileName = (String)propsMap.get("NAME")) == null) {
            throw new Exception("File name must be specified");
        }
        for (String dummyRef : dummyRefs = FileTemplateUtil.calculateAttributes(template.getText(), propsMap, true)) {
            propsMap.put(dummyRef, "");
        }
        handler.prepareProperties(propsMap);
        final Map<String, Object> props_ = propsMap;
        final String fileName_ = fileName;
        String mergedText = (String)ClassLoaderUtil.runWithClassLoader((ClassLoader)(classLoader != null ? classLoader : FileTemplateUtil.class.getClassLoader()), (ThrowableComputable)new ThrowableComputable<String, IOException>(){

            public String compute() throws IOException {
                return template.getText(props_);
            }
        });
        final String templateText = StringUtil.convertLineSeparators((String)mergedText);
        final Exception[] commandException = new Exception[1];
        final PsiElement[] result = new PsiElement[1];
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result[0] = handler.createFromTemplate(project, directory, fileName_, template, templateText, props_);
                        }
                        catch (Exception ex) {
                            commandException[0] = ex;
                        }
                    }
                });
            }
        }, template.isTemplateOfType((FileType)StdFileTypes.JAVA) && !INTERNAL_PACKAGE_INFO_TEMPLATE_NAME.equals(template.getName()) ? IdeBundle.message((String)"command.create.class.from.template", (Object[])new Object[0]) : IdeBundle.message((String)"command.create.file.from.template", (Object[])new Object[0]), null);
        if (commandException[0] != null) {
            throw commandException[0];
        }
        return result[0];
    }

    public static CreateFromTemplateHandler findHandler(FileTemplate template) {
        for (CreateFromTemplateHandler handler : (CreateFromTemplateHandler[])Extensions.getExtensions(CreateFromTemplateHandler.EP_NAME)) {
            if (!handler.handlesTemplate(template)) continue;
            return handler;
        }
        return ourDefaultCreateFromTemplateHandler;
    }

    public static void fillDefaultProperties(Properties props, PsiDirectory directory) {
        DefaultTemplatePropertiesProvider[] providers;
        for (DefaultTemplatePropertiesProvider provider : providers = (DefaultTemplatePropertiesProvider[])Extensions.getExtensions((ExtensionPointName)DefaultTemplatePropertiesProvider.EP_NAME)) {
            provider.fillProperties(directory, props);
        }
    }

    public static String indent(String methodText, Project project, FileType fileType) {
        int indent = CodeStyleSettingsManager.getSettings((Project)project).getIndentSize(fileType);
        return methodText.replaceAll("\n", "\n" + StringUtil.repeatSymbol((char)' ', (int)indent));
    }

    public static boolean canCreateFromTemplate(PsiDirectory[] dirs, FileTemplate template) {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        if (fileType.equals(FileTypes.UNKNOWN)) {
            return false;
        }
        CreateFromTemplateHandler handler = FileTemplateUtil.findHandler(template);
        return handler.canCreate(dirs);
    }

    @Nullable
    public static Icon getIcon(@NotNull FileTemplate fileTemplate) {
        if (fileTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTemplate", "com/intellij/ide/fileTemplates/FileTemplateUtil", "getIcon"));
        }
        return FileTypeManager.getInstance().getFileTypeByExtension(fileTemplate.getExtension()).getIcon();
    }

    public static void putAll(Map<String, Object> props, Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            props.put(s, p.getProperty(s));
        }
    }

    static {
        try {
            final FileTemplateManager templateManager = FileTemplateManager.getInstance();
            LogSystem emptyLogSystem = new LogSystem(){

                public void init(RuntimeServices runtimeServices) throws Exception {
                }

                public void logVelocityMessage(int i, String s) {
                }
            };
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)emptyLogSystem);
            Velocity.setProperty((String)"input.encoding", (Object)"UTF-8");
            Velocity.setProperty((String)"parser.pool.size", (Object)3);
            Velocity.setProperty((String)"resource.loader", (Object)"includes");
            Velocity.setProperty((String)"includes.resource.loader.instance", (Object)new ResourceLoader(){

                public void init(ExtendedProperties configuration) {
                }

                public InputStream getResourceStream(String resourceName) throws ResourceNotFoundException {
                    FileTemplate include = templateManager.getPattern(resourceName);
                    if (include == null) {
                        throw new ResourceNotFoundException("Template not found: " + resourceName);
                    }
                    String text = include.getText();
                    try {
                        return new ByteArrayInputStream(text.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }

                public boolean isSourceModified(Resource resource) {
                    return true;
                }

                public long getLastModified(Resource resource) {
                    return 0L;
                }
            });
            Velocity.init();
        }
        catch (Exception e) {
            LOG.error("Unable to init Velocity", (Throwable)e);
        }
    }
}

