/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenCentralSourceSearcher
extends SourceSearcher {
    private static final Logger LOG = Logger.getInstance(MavenCentralSourceSearcher.class);

    @Override
    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version) throws SourceSearchException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/MavenCentralSourceSearcher", "findSourceJar"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/intellij/jarFinder/MavenCentralSourceSearcher", "findSourceJar"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/jarFinder/MavenCentralSourceSearcher", "findSourceJar"));
        }
        try {
            indicator.setIndeterminate(true);
            indicator.setText("Connecting to http://search.maven.org");
            indicator.checkCanceled();
            String url = "http://search.maven.org/solrsearch/select?rows=3&wt=xml&q=a:%22" + artifactId + "%22%20AND%20v:%22" + version + "%22%20AND%20l:%22sources%22";
            Document document = MavenCentralSourceSearcher.readDocumentCancelable(indicator, url);
            indicator.checkCanceled();
            List artifactList = XPath.newInstance((String)"/response/result/doc/str[@name='g']").selectNodes((Object)document);
            if (artifactList.isEmpty()) {
                return null;
            }
            if (artifactList.size() != 1) {
                return null;
            }
            Element element = (Element)artifactList.get(0);
            String groupId = element.getValue();
            String downloadUrl = "http://search.maven.org/remotecontent?filepath=" + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + "-sources.jar";
            return downloadUrl;
        }
        catch (JDOMException e) {
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Failed to parse response from server. See log for more details.");
        }
        catch (IOException e) {
            indicator.checkCanceled();
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Connection problem. See log for more details.");
        }
    }
}

