/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class DiffRangeMarker
extends RangeMarkerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker");
    private RangeInvalidListener myListener;

    DiffRangeMarker(@NotNull DocumentEx document, @NotNull TextRange range, RangeInvalidListener listener) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker", "<init>"));
        }
        super(document, range.getStartOffset(), range.getEndOffset(), true);
        this.myListener = listener;
        if (this.myListener != null) {
            InvalidRangeDispatcher.addClient(document);
        }
    }

    @Override
    protected void changedUpdateImpl(DocumentEvent e) {
        super.changedUpdateImpl(e);
        if (!this.isValid() && this.myListener != null) {
            InvalidRangeDispatcher.notify(e.getDocument(), this.myListener);
        }
    }

    public void removeListener(RangeInvalidListener listener) {
        LOG.assertTrue(this.myListener == listener || this.myListener == null);
        this.myListener = null;
        InvalidRangeDispatcher.removeClient(this.getDocument());
    }

    private static class InvalidRangeDispatcher
    extends DocumentAdapter {
        private static final Key<InvalidRangeDispatcher> KEY = Key.create((String)"deferedNotifier");
        private final ArrayList<RangeInvalidListener> myDeferedNotifications = new ArrayList();
        private int myClientCount = 0;

        private InvalidRangeDispatcher() {
        }

        public void documentChanged(DocumentEvent e) {
            if (this.myDeferedNotifications.isEmpty()) {
                return;
            }
            RangeInvalidListener[] notifications = this.myDeferedNotifications.toArray(new RangeInvalidListener[this.myDeferedNotifications.size()]);
            this.myDeferedNotifications.clear();
            for (RangeInvalidListener notification : notifications) {
                notification.onRangeInvalidated();
            }
        }

        public static void notify(Document document, RangeInvalidListener listener) {
            InvalidRangeDispatcher notifier = (InvalidRangeDispatcher)((Object)document.getUserData(KEY));
            notifier.myDeferedNotifications.add(listener);
        }

        public static void addClient(@NotNull Document document) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/diff/impl/incrementalMerge/DiffRangeMarker$InvalidRangeDispatcher", "addClient"));
            }
            InvalidRangeDispatcher notifier = (InvalidRangeDispatcher)((Object)document.getUserData(KEY));
            if (notifier == null) {
                notifier = new InvalidRangeDispatcher();
                document.putUserData(KEY, (Object)notifier);
                document.addDocumentListener((DocumentListener)notifier);
            }
            ++notifier.myClientCount;
        }

        private static void removeClient(Document document) {
            InvalidRangeDispatcher notifier = (InvalidRangeDispatcher)((Object)document.getUserData(KEY));
            notifier.onClientRemoved(document);
        }

        private void onClientRemoved(Document document) {
            --this.myClientCount;
            LOG.assertTrue(this.myClientCount >= 0);
            if (this.myClientCount == 0) {
                document.putUserData(KEY, null);
                document.removeDocumentListener((DocumentListener)this);
            }
        }
    }

    public static interface RangeInvalidListener {
        public void onRangeInvalidated();
    }
}

