/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemTasksPanel;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final NotificationGroup myNotificationGroup;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory", "<init>"));
        }
        this.myExternalSystemId = id;
        this.myNotificationGroup = NotificationGroup.toolWindowGroup((String)("notification.group.id." + id.toString().toLowerCase(Locale.ENGLISH)), (String)this.myExternalSystemId.getReadableName());
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setTitle(this.myExternalSystemId.getReadableName());
        ContentManager contentManager = toolWindow.getContentManager();
        String tasksTitle = ExternalSystemBundle.message((String)"tool.window.title.tasks", (Object[])new Object[0]);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
        assert (manager != null);
        ExternalSystemTasksPanel panel = new ExternalSystemTasksPanel(project, this.myExternalSystemId, this.myNotificationGroup);
        ContentImpl tasksContent = new ContentImpl((JComponent)((Object)panel), tasksTitle, true);
        contentManager.addContent((Content)tasksContent);
    }
}

