/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(file="$APP_CONFIG$/keymap.xml", roamingType=RoamingType.PER_PLATFORM)})
public class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element>,
ExportableApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.keymap.KeymapManager");
    private final List<KeymapManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myActiveKeymapName;
    private final Map<String, String> myBoundShortcuts = new HashMap<String, String>();
    @NonNls
    private static final String KEYMAP = "keymap";
    @NonNls
    private static final String KEYMAPS = "keymaps";
    @NonNls
    private static final String ACTIVE_KEYMAP = "active_keymap";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private final SchemesManager<Keymap, KeymapImpl> mySchemesManager;
    public static boolean ourKeymapManagerInitialized = false;

    KeymapManagerImpl(DefaultKeymap defaultKeymap, SchemesManagerFactory factory) {
        this.mySchemesManager = factory.createSchemesManager("$ROOT_CONFIG$/keymaps", (SchemeProcessor)new BaseSchemeProcessor<KeymapImpl>(){

            public KeymapImpl readScheme(@NotNull Document schemeContent) throws InvalidDataException, IOException, JDOMException {
                if (schemeContent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeContent", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "readScheme"));
                }
                return KeymapManagerImpl.this.readKeymap(schemeContent);
            }

            public Element writeScheme(@NotNull KeymapImpl scheme) throws WriteExternalException {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "writeScheme"));
                }
                return scheme.writeExternal();
            }

            public boolean shouldBeSaved(@NotNull KeymapImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "shouldBeSaved"));
                }
                return scheme.canModify();
            }
        }, RoamingType.PER_USER);
        Keymap[] keymaps = defaultKeymap.getKeymaps();
        String systemDefaultKeymap = WelcomeWizardUtil.getWizardMacKeymap() != null ? WelcomeWizardUtil.getWizardMacKeymap() : defaultKeymap.getDefaultKeymapName();
        for (Keymap keymap : keymaps) {
            this.addKeymap(keymap);
            if (!systemDefaultKeymap.equals(keymap.getName())) continue;
            this.setActiveKeymap(keymap);
        }
        this.load();
        if (Registry.is((String)"editor.add.carets.on.double.control.arrows")) {
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorCloneCaretAbove", 17, 38);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorCloneCaretBelow", 17, 40);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLeftWithSelection", 17, 37);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorRightWithSelection", 17, 39);
        }
        ourKeymapManagerInitialized = true;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{new File(PathManager.getOptionsPath() + File.separatorChar + "keymap.xml"), KeymapManagerImpl.getKeymapDirectory(true)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = KeyMapBundle.message((String)"key.maps.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "getPresentableName"));
        }
        return string;
    }

    @Override
    public Keymap[] getAllKeymaps() {
        ArrayList<Keymap> answer = new ArrayList<Keymap>();
        for (Keymap keymap : this.mySchemesManager.getAllSchemes()) {
            if (keymap.getPresentableName().startsWith("$")) continue;
            answer.add(keymap);
        }
        return answer.toArray(new Keymap[answer.size()]);
    }

    public Keymap[] getAllIncludingDefaultsKeymaps() {
        List keymaps = this.mySchemesManager.getAllSchemes();
        return keymaps.toArray(new Keymap[keymaps.size()]);
    }

    @Nullable
    public Keymap getKeymap(String name) {
        return (Keymap)this.mySchemesManager.findSchemeByName(name);
    }

    public Keymap getActiveKeymap() {
        return (Keymap)this.mySchemesManager.getCurrentScheme();
    }

    @Override
    public void setActiveKeymap(Keymap activeKeymap) {
        this.mySchemesManager.setCurrentSchemeName(activeKeymap == null ? null : activeKeymap.getName());
        this.fireActiveKeymapChanged();
    }

    @Override
    public void bindShortcuts(String sourceActionId, String targetActionId) {
        this.myBoundShortcuts.put(targetActionId, sourceActionId);
    }

    @Override
    public void unbindShortcuts(String targetActionId) {
        this.myBoundShortcuts.remove(targetActionId);
    }

    @Override
    public Set<String> getBoundActions() {
        return this.myBoundShortcuts.keySet();
    }

    @Override
    public String getActionBinding(String actionId) {
        return this.myBoundShortcuts.get(actionId);
    }

    @Override
    public SchemesManager<Keymap, KeymapImpl> getSchemesManager() {
        return this.mySchemesManager;
    }

    public void addKeymap(Keymap keymap) {
        this.mySchemesManager.addNewScheme((Scheme)keymap, true);
    }

    public void removeAllKeymapsExceptUnmodifiable() {
        for (Keymap keymap : this.mySchemesManager.getAllSchemes()) {
            if (!keymap.canModify()) continue;
            this.mySchemesManager.removeScheme((Scheme)keymap);
        }
        this.mySchemesManager.setCurrentSchemeName(null);
        List keymaps = this.mySchemesManager.getAllSchemes();
        if (keymaps.size() > 0) {
            this.mySchemesManager.setCurrentSchemeName(((Keymap)keymaps.iterator().next()).getName());
        }
    }

    public String getExternalFileName() {
        return KEYMAP;
    }

    public Element getState() {
        Element result = new Element("component");
        try {
            this.writeExternal(result);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        Keymap keymap;
        Element child = element.getChild(ACTIVE_KEYMAP);
        if (child != null) {
            this.myActiveKeymapName = child.getAttributeValue(NAME_ATTRIBUTE);
        }
        if (this.myActiveKeymapName != null && (keymap = this.getKeymap(this.myActiveKeymapName)) != null) {
            this.setActiveKeymap(keymap);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.mySchemesManager.getCurrentScheme() != null) {
            Element e = new Element(ACTIVE_KEYMAP);
            Keymap currentScheme = (Keymap)this.mySchemesManager.getCurrentScheme();
            if (currentScheme != null) {
                e.setAttribute(NAME_ATTRIBUTE, currentScheme.getName());
            }
            element.addContent(e);
        }
    }

    private void load() {
        this.mySchemesManager.loadSchemes();
    }

    @NotNull
    private KeymapImpl readKeymap(Document document) throws JDOMException, InvalidDataException, IOException {
        if (document == null) {
            throw new InvalidDataException();
        }
        Element root = document.getRootElement();
        if (root == null || !KEYMAP.equals(root.getName())) {
            throw new InvalidDataException();
        }
        KeymapImpl keymap = new KeymapImpl();
        keymap.readExternal(root, this.getAllIncludingDefaultsKeymaps());
        KeymapImpl keymapImpl = keymap;
        if (keymapImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "readKeymap"));
        }
        return keymapImpl;
    }

    @Nullable
    private static File getKeymapDirectory(boolean toCreate) {
        String directoryPath = PathManager.getConfigPath() + File.separator + KEYMAPS;
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (!toCreate) {
                return null;
            }
            if (!directory.mkdir()) {
                LOG.error("Cannot create directory: " + directory.getAbsolutePath());
                return null;
            }
        }
        return directory;
    }

    private void fireActiveKeymapChanged() {
        for (KeymapManagerListener listener : this.myListeners) {
            listener.activeKeymapChanged((Keymap)this.mySchemesManager.getCurrentScheme());
        }
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "addKeymapManagerListener"));
        }
        this.pollQueue();
        this.myListeners.add(listener);
    }

    private void pollQueue() {
        for (KeymapManagerListener listener : this.myListeners) {
            if (!(listener instanceof WeakKeymapManagerListener) || !((WeakKeymapManagerListener)listener).isDead()) continue;
            this.myListeners.remove(listener);
        }
    }

    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "removeKeymapManagerListener"));
        }
        this.pollQueue();
        this.myListeners.remove(listener);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "addWeakListener"));
        }
        this.addKeymapManagerListener(new WeakKeymapManagerListener(this, listener));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        if (listenerToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerToRemove", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "removeWeakListener"));
        }
        for (KeymapManagerListener listener : this.myListeners) {
            if (!(listener instanceof WeakKeymapManagerListener) || !((WeakKeymapManagerListener)listener).isWrapped(listenerToRemove)) continue;
            this.myListeners.remove(listener);
        }
    }

    @NotNull
    public String getComponentName() {
        if ("KeymapManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "getComponentName"));
        }
        return "KeymapManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

