/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.Consumer;
import com.intellij.util.HttpRequests;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDownloader {
    private static final Logger LOG = Logger.getInstance((String)("#" + PluginDownloader.class.getName()));
    @NonNls
    private static final String FILENAME = "filename=";
    private final String myPluginId;
    private String myPluginUrl;
    private String myPluginVersion;
    private String myFileName;
    private String myPluginName;
    private BuildNumber myBuildNumber;
    private File myFile;
    private File myOldFile;
    private String myDescription;
    private List<PluginId> myDepends;
    private IdeaPluginDescriptor myDescriptor;

    public PluginDownloader(String pluginId, String pluginUrl, String pluginVersion) {
        this.myPluginId = pluginId;
        this.myPluginUrl = pluginUrl;
        this.myPluginVersion = pluginVersion;
    }

    public PluginDownloader(String pluginId, String pluginUrl, String pluginVersion, String fileName, String pluginName, BuildNumber buildNumber) {
        this.myPluginId = pluginId;
        this.myPluginUrl = pluginUrl;
        this.myPluginVersion = pluginVersion;
        this.myFileName = fileName;
        this.myPluginName = pluginName;
        this.myBuildNumber = buildNumber;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator progressIndicator) throws IOException {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "prepareToInstall"));
        }
        return this.prepareToInstall(progressIndicator, this.myBuildNumber);
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator progressIndicator, @Nullable BuildNumber forBuildNumber) throws IOException {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "prepareToInstall"));
        }
        if (this.myFile != null) {
            return true;
        }
        IdeaPluginDescriptor descriptor = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManager.isPluginInstalled(PluginId.getId((String)this.myPluginId))) {
            descriptor = PluginManager.getPlugin(PluginId.getId((String)this.myPluginId));
            LOG.assertTrue(descriptor != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBroken(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myOldFile = descriptor.getPath();
        }
        String errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
        try {
            this.myFile = this.downloadPlugin(progressIndicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            if (ApplicationManager.getApplication() != null) {
                final String text = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                final String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)text, (String)title);
                    }
                });
            }
            return false;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDownloader.loadDescriptionFromJar(this.myFile);
        if (actualDescriptor != null) {
            if (InstalledPluginsTableModel.wasUpdated(actualDescriptor.getPluginId())) {
                return false;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor != null && PluginDownloader.compareVersionsSkipBroken(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.setDescriptor(actualDescriptor);
            if (PluginManagerCore.isIncompatible(actualDescriptor, forBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since: " + actualDescriptor.getSinceBuild() + ", until: " + actualDescriptor.getUntilBuild() + ")");
                return false;
            }
        }
        return true;
    }

    public static int compareVersionsSkipBroken(IdeaPluginDescriptor descriptor, String newPluginVersion) {
        int state = StringUtil.compareVersionNumbers((String)newPluginVersion, (String)descriptor.getVersion());
        if (PluginManagerCore.isBrokenPlugin(descriptor) && state < 0) {
            state = 1;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptionFromJar(File file) throws IOException {
        IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptorFromJar(file);
        if (descriptor == null && file.getName().endsWith(".zip")) {
            File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
            try {
                ZipUtil.extract((File)file, (File)outputDir, null);
                File[] files = outputDir.listFiles();
                if (files != null && files.length == 1) {
                    descriptor = PluginManagerCore.loadDescriptor(files[0], "plugin.xml");
                }
            }
            finally {
                FileUtil.delete((File)outputDir);
            }
        }
        return descriptor;
    }

    public void install() throws IOException {
        LOG.assertTrue(this.myFile != null);
        if (this.myOldFile != null) {
            StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(this.myOldFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
        }
        PluginDownloader.install(this.myFile, this.getPluginName());
    }

    public static void install(File fromFile, String pluginName) throws IOException {
        PluginDownloader.install(fromFile, pluginName, true);
    }

    public static void install(File fromFile, String pluginName, boolean deleteFromFile) throws IOException {
        if (fromFile.getName().endsWith(".jar")) {
            StartupActionScriptManager.CopyCommand copyPlugin = new StartupActionScriptManager.CopyCommand(fromFile, new File(PathManager.getPluginsPath() + File.separator + fromFile.getName()));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)copyPlugin);
        } else {
            String unzipPath = ZipUtil.isZipContainsFolder((File)fromFile) ? PathManager.getPluginsPath() : PathManager.getPluginsPath() + File.separator + pluginName;
            StartupActionScriptManager.UnzipCommand unzip = new StartupActionScriptManager.UnzipCommand(fromFile, new File(unzipPath));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)unzip);
        }
        if (deleteFromFile) {
            StartupActionScriptManager.DeleteCommand deleteTemp = new StartupActionScriptManager.DeleteCommand(fromFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteTemp);
        }
    }

    @NotNull
    private File downloadPlugin(final @NotNull ProgressIndicator progressIndicator) throws IOException {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "downloadPlugin"));
        }
        File pluginsTemp = new File(PathManager.getPluginTempPath());
        if (!pluginsTemp.exists() && !pluginsTemp.mkdirs()) {
            throw new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        final File file = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        progressIndicator.checkCanceled();
        progressIndicator.setText(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        File file2 = HttpRequests.request(this.myPluginUrl).supportGzip(false).effectiveUrlConsumer(new Consumer<String>(){

            public void consume(String url) {
                PluginDownloader.this.myPluginUrl = url;
            }
        }).get(new ThrowableConvertor<URLConnection, File, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public File convert(URLConnection connection) throws IOException {
                progressIndicator.checkCanceled();
                InputStream input = HttpRequests.getInputStream(connection);
                try {
                    FileOutputStream fileOut = new FileOutputStream(file);
                    try {
                        NetUtils.copyStreamContent((ProgressIndicator)progressIndicator, (InputStream)input, (OutputStream)fileOut, (int)connection.getContentLength());
                    }
                    finally {
                        ((OutputStream)fileOut).close();
                    }
                }
                finally {
                    input.close();
                }
                if (PluginDownloader.this.myFileName == null) {
                    PluginDownloader.this.myFileName = PluginDownloader.this.guessFileName(connection, file);
                }
                File newFile = new File(file.getParentFile(), PluginDownloader.this.myFileName);
                FileUtil.rename((File)file, (File)newFile);
                return newFile;
            }
        });
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "downloadPlugin"));
        }
        return file2;
    }

    @NotNull
    private String guessFileName(@NotNull URLConnection connection, @NotNull File file) throws IOException {
        String usedURL;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "guessFileName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "guessFileName"));
        }
        String fileName = null;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.contains(FILENAME)) {
            int startIdx = contentDisposition.indexOf(FILENAME);
            int endIdx = contentDisposition.indexOf(59, startIdx);
            fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        }
        if (fileName == null && ((fileName = (usedURL = connection.getURL().toString()).substring(usedURL.lastIndexOf("/") + 1)).length() == 0 || fileName.contains("?"))) {
            fileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf("/") + 1);
        }
        if (!PathUtil.isValidFileName(fileName)) {
            FileUtil.delete((File)file);
            throw new IOException("Invalid filename returned by a server");
        }
        String string = fileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "guessFileName"));
        }
        return string;
    }

    public String getPluginId() {
        return this.myPluginId;
    }

    public String getFileName() {
        if (this.myFileName == null) {
            this.myFileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf("/") + 1);
        }
        return this.myFileName;
    }

    public String getPluginName() {
        if (this.myPluginName == null) {
            this.myPluginName = FileUtil.getNameWithoutExtension((String)this.getFileName());
        }
        return this.myPluginName;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDepends(List<PluginId> depends) {
        this.myDepends = depends;
    }

    public List<PluginId> getDepends() {
        return this.myDepends;
    }

    public static PluginDownloader createDownloader(IdeaPluginDescriptor descriptor) throws UnsupportedEncodingException {
        return PluginDownloader.createDownloader(descriptor, null);
    }

    public static PluginDownloader createDownloader(IdeaPluginDescriptor descriptor, BuildNumber buildNumber) throws UnsupportedEncodingException {
        PluginDownloader downloader = new PluginDownloader(descriptor.getPluginId().getIdString(), UpdateChecker.getDownloadUrl(descriptor, buildNumber), descriptor.getVersion(), null, descriptor.getName(), buildNumber);
        downloader.setDescriptor(descriptor);
        return downloader;
    }

    @Nullable
    public static VirtualFile findPluginFile(String pluginUrl, String host) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        VirtualFile pluginFile = fileManager.findFileByUrl(pluginUrl);
        if (pluginFile == null) {
            VirtualFile hostFile = fileManager.findFileByUrl(host);
            if (hostFile == null) {
                LOG.error("can't find file by url '" + host + "'");
                return null;
            }
            pluginFile = PluginDownloader.findPluginByRelativePath(hostFile.getParent(), pluginUrl, hostFile.getFileSystem());
        }
        if (pluginFile == null) {
            LOG.error("can't find '" + pluginUrl + "' relative to '" + host + "'");
            return null;
        }
        return pluginFile;
    }

    @Nullable
    private static VirtualFile findPluginByRelativePath(@NotNull VirtualFile hostFile, @NotNull @NonNls String relPath, @NotNull VirtualFileSystem fileSystem) {
        String name;
        VirtualFile child;
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "findPluginByRelativePath"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "findPluginByRelativePath"));
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/updateSettings/impl/PluginDownloader", "findPluginByRelativePath"));
        }
        if (relPath.length() == 0) {
            return hostFile;
        }
        int index = relPath.indexOf(47);
        if (index < 0) {
            index = relPath.length();
        }
        if ((child = (name = relPath.substring(0, index)).equals(".") ? hostFile : (name.equals("..") ? hostFile.getParent() : fileSystem.findFileByPath(hostFile.getPath() + "/" + name))) == null) {
            return null;
        }
        if (index < relPath.length()) {
            return PluginDownloader.findPluginByRelativePath(child, relPath.substring(index + 1), fileSystem);
        }
        return child;
    }

    @Nullable
    public static PluginNode createPluginNode(String host, PluginDownloader downloader) {
        if (downloader.getDescriptor() instanceof PluginNode) {
            return (PluginNode)downloader.getDescriptor();
        }
        VirtualFile pluginFile = PluginDownloader.findPluginFile(downloader.myPluginUrl, host);
        if (pluginFile != null) {
            PluginNode node = new PluginNode(PluginId.getId((String)downloader.getPluginId()));
            node.setName(downloader.getPluginName());
            node.setVersion(downloader.getPluginVersion());
            node.setRepositoryName(host);
            node.setDownloadUrl(pluginFile.getUrl());
            node.setDepends(downloader.getDepends(), null);
            node.setDescription(downloader.getDescription());
            return node;
        }
        return null;
    }

    public void setDescriptor(IdeaPluginDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }
}

