/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Getter;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LazyConfigurable
implements UnnamedConfigurable {
    private final Getter<Configurable> myGetter;
    private Configurable myDelegate;
    private final JPanel myParentPanel;

    public LazyConfigurable(Getter<Configurable> getter, JPanel parentPanel) {
        this.myGetter = getter;
        this.myParentPanel = parentPanel;
        this.myParentPanel.setLayout(new BorderLayout());
        this.myParentPanel.removeAll();
    }

    public void apply() throws ConfigurationException {
        if (this.myDelegate != null) {
            this.myDelegate.apply();
        }
    }

    public JComponent createComponent() {
        if (this.myDelegate == null) {
            this.myDelegate = (Configurable)this.myGetter.get();
            this.myParentPanel.add((Component)this.myDelegate.createComponent(), "Center");
        }
        return this.myParentPanel;
    }

    public boolean isModified() {
        if (this.myDelegate != null) {
            return this.myDelegate.isModified();
        }
        return false;
    }

    public void reset() {
        if (this.myDelegate != null) {
            this.myDelegate.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myDelegate != null) {
            this.myDelegate.disposeUIResources();
        }
    }

    public JPanel getParentPanel() {
        return this.myParentPanel;
    }
}

