/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetectorImpl;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectableIndentOptionsProvider
extends FileIndentOptionsProvider {
    private boolean myIsEnabledInTest;

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "getIndentOptions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "getIndentOptions"));
        }
        return this.isEnabled(settings, file) ? new IndentOptionsDetectorImpl(file).getIndentOptions() : null;
    }

    public boolean useOnFullReformat() {
        return false;
    }

    public void setEnabledInTest(boolean isEnabledInTest) {
        this.myIsEnabledInTest = isEnabledInTest;
    }

    private boolean isEnabled(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectableIndentOptionsProvider", "isEnabled"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myIsEnabledInTest;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null || vFile instanceof LightVirtualFile) {
            return false;
        }
        return settings.AUTODETECT_INDENTS;
    }

    @Nullable
    public static DetectableIndentOptionsProvider getInstance() {
        return (DetectableIndentOptionsProvider)((Object)FileIndentOptionsProvider.EP_NAME.findExtension(DetectableIndentOptionsProvider.class));
    }
}

