/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.JavaMoveClassesOrPackagesHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerToUpperHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersHandler;
import com.intellij.refactoring.util.RadioUpDownListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nullable;

public class MoveInnerToUpperOrMembersHandler
extends MoveHandlerDelegate {
    @Override
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return MoveInnerToUpperOrMembersHandler.isStaticInnerClass(element);
    }

    private static boolean isStaticInnerClass(PsiElement element) {
        return element instanceof PsiClass && element.getParent() instanceof PsiClass && ((PsiClass)element).hasModifierProperty("static");
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        SelectInnerOrMembersRefactoringDialog dialog = new SelectInnerOrMembersRefactoringDialog((PsiClass)elements[0], project);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        MoveHandlerDelegate delegate = dialog.getRefactoringHandler();
        if (delegate != null) {
            delegate.doMove(project, elements, targetContainer, callback);
        }
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (MoveInnerToUpperOrMembersHandler.isStaticInnerClass(element) && !JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            MoveHandlerDelegate moveHandlerDelegate;
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.move.moveInner");
            PsiElement targetContainer = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
            PsiClass aClass = (PsiClass)element;
            SelectInnerOrMembersRefactoringDialog dialog = new SelectInnerOrMembersRefactoringDialog(aClass, project);
            dialog.show();
            if (dialog.isOK() && (moveHandlerDelegate = dialog.getRefactoringHandler()) != null) {
                moveHandlerDelegate.doMove(project, new PsiElement[]{aClass}, targetContainer, null);
            }
            return true;
        }
        return false;
    }

    private static class SelectInnerOrMembersRefactoringDialog
    extends DialogWrapper {
        private JRadioButton myRbMoveInner;
        private JRadioButton myRbMoveMembers;
        private final String myClassName;

        public SelectInnerOrMembersRefactoringDialog(PsiClass innerClass, Project project) {
            super(project, true);
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.myClassName = innerClass.getName();
            this.init();
        }

        protected JComponent createNorthPanel() {
            return new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRbMoveInner;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.refactoring.move.MoveHandler.SelectRefactoringDialog";
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            this.myRbMoveInner = new JRadioButton();
            this.myRbMoveInner.setText(RefactoringBundle.message((String)"move.inner.class.to.upper.level", (Object[])new Object[]{this.myClassName}));
            this.myRbMoveInner.setSelected(true);
            this.myRbMoveMembers = new JRadioButton();
            this.myRbMoveMembers.setText(RefactoringBundle.message((String)"move.inner.class.to.another.class", (Object[])new Object[]{this.myClassName}));
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.myRbMoveInner);
            gr.add(this.myRbMoveMembers);
            new RadioUpDownListener(this.myRbMoveInner, this.myRbMoveMembers);
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(5));
            box.add(this.myRbMoveInner);
            box.add(this.myRbMoveMembers);
            panel.add((Component)box, "Center");
            return panel;
        }

        @Nullable
        public MoveHandlerDelegate getRefactoringHandler() {
            if (this.myRbMoveInner.isSelected()) {
                return new MoveInnerToUpperHandler();
            }
            if (this.myRbMoveMembers.isSelected()) {
                return new MoveMembersHandler();
            }
            return null;
        }
    }
}

