/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeActionBase;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ServerActionBase
extends ServersTreeActionBase {
    protected ServerActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @Override
    protected final boolean isEnabled(@NotNull ServersToolWindowContent content, AnActionEvent e) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServerActionBase", "isEnabled"));
        }
        Set<ServerNode> selectedServerNodes = content.getSelectedServerNodes();
        Set selectedElements = content.getBuilder().getSelectedElements();
        if (selectedElements.size() != selectedServerNodes.size() || selectedElements.isEmpty()) {
            return false;
        }
        for (ServerNode selectedServer : selectedServerNodes) {
            if (this.isEnabledForServer(selectedServer)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServerActionBase", "doActionPerformed"));
        }
        for (ServerNode node : content.getSelectedServerNodes()) {
            this.performAction(node);
        }
    }

    protected abstract void performAction(@NotNull ServerNode var1);

    protected abstract boolean isEnabledForServer(@NotNull ServerNode var1);
}

