/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TestLogger;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;

public class TestLoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private static final String LOG_DIR = "testlog";
    private boolean myInitialized = false;

    private TestLoggerFactory() {
    }

    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(String name) {
        if (!this.myInitialized) {
            this.init();
        }
        return new TestLogger(Logger.getLogger((String)name));
    }

    private void init() {
        try {
            File logXmlFile = new File(PathManager.getHomePath(), "test-log.xml");
            if (!logXmlFile.exists()) {
                logXmlFile = new File(PathManager.getBinPath(), "log.xml");
            }
            if (!logXmlFile.exists()) {
                return;
            }
            String logDir = TestLoggerFactory.getTestLogDir();
            String text = FileUtil.loadFile((File)logXmlFile);
            text = StringUtil.replace((String)text, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)logDir, (String)"\\", (String)"\\\\"));
            File logDirFile = new File(logDir);
            if (!logDirFile.mkdirs() && !logDirFile.exists()) {
                throw new IOException("Unable to create log dir: " + logDirFile);
            }
            System.setProperty("log4j.defaultInitOverride", "true");
            DOMConfigurator domConfigurator = new DOMConfigurator();
            try {
                domConfigurator.doConfigure((Reader)new StringReader(text), LogManager.getLoggerRepository());
            }
            catch (ClassCastException e) {
                System.err.println("log.xml content:\n" + text);
                throw e;
            }
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTestLogDir() {
        return PathManager.getSystemPath() + "/" + LOG_DIR;
    }

    public static void dumpLogToStdout(@NotNull String testStartMarker) throws IOException {
        if (testStartMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartMarker", "com/intellij/testFramework/TestLoggerFactory", "dumpLogToStdout"));
        }
        File ideaLog = new File(TestLoggerFactory.getTestLogDir(), "idea.log");
        if (ideaLog.exists()) {
            String logText = FileUtil.loadFile((File)ideaLog);
            Pattern logStart = Pattern.compile("[0-9\\-, :\\[\\]]+(DEBUG|INFO|ERROR) - ");
            System.out.println("\n\nIdea Log:");
            for (String line : StringUtil.splitByLines((String)logText.substring(Math.max(0, logText.lastIndexOf(testStartMarker))))) {
                Matcher matcher = logStart.matcher(line);
                int lineStart = matcher.lookingAt() ? matcher.end() : 0;
                System.out.println(line.substring(lineStart));
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, String ... categories) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/TestLoggerFactory", "enableDebugLogging"));
        }
        for (String category : categories) {
            final com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)category);
            logger.setLevel(Level.DEBUG);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    logger.setLevel(Level.INFO);
                }
            });
        }
    }
}

