/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.AbstractToolBeforeRunTask;
import com.intellij.tools.BaseToolsPanel;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolBeforeRunTaskProvider;
import com.intellij.tools.ToolSelectDialog;
import com.intellij.tools.ToolsBundle;
import javax.swing.Icon;

public abstract class AbstractToolBeforeRunTaskProvider<T extends AbstractToolBeforeRunTask>
extends BeforeRunTaskProvider<T> {
    protected static final Logger LOG = Logger.getInstance((String)("#" + ToolBeforeRunTaskProvider.class.getName()));

    public Icon getIcon() {
        return AllIcons.General.ExternalToolsSmall;
    }

    public boolean configureTask(RunConfiguration runConfiguration, T task) {
        ToolSelectDialog dialog = new ToolSelectDialog(runConfiguration.getProject(), ((AbstractToolBeforeRunTask)((Object)task)).getToolActionId(), this.createToolsPanel());
        dialog.show();
        if (!dialog.isOK()) {
            return false;
        }
        boolean isModified = dialog.isModified();
        Tool selectedTool = dialog.getSelectedTool();
        LOG.assertTrue(selectedTool != null);
        String selectedToolId = selectedTool.getActionId();
        String oldToolId = ((AbstractToolBeforeRunTask)((Object)task)).getToolActionId();
        if (oldToolId != null && oldToolId.equals(selectedToolId)) {
            return isModified;
        }
        ((AbstractToolBeforeRunTask)((Object)task)).setToolActionId(selectedToolId);
        return true;
    }

    protected abstract BaseToolsPanel createToolsPanel();

    public boolean canExecuteTask(RunConfiguration configuration, T task) {
        return ((AbstractToolBeforeRunTask)((Object)task)).isExecutable();
    }

    public String getDescription(T task) {
        String actionId = ((AbstractToolBeforeRunTask)((Object)task)).getToolActionId();
        if (actionId == null) {
            LOG.error("Null id");
            return ToolsBundle.message("tools.unknown.external.tool", new Object[0]);
        }
        Object tool = ((AbstractToolBeforeRunTask)((Object)task)).findCorrespondingTool();
        if (tool == null) {
            return ToolsBundle.message("tools.unknown.external.tool", new Object[0]);
        }
        String groupName = ((Tool)tool).getGroup();
        return ToolsBundle.message("tools.before.run.description", StringUtil.isEmpty((String)groupName) ? ((Tool)tool).getName() : groupName + "/" + ((Tool)tool).getName());
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, ExecutionEnvironment env, T task) {
        if (!((AbstractToolBeforeRunTask)((Object)task)).isExecutable()) {
            return false;
        }
        return ((AbstractToolBeforeRunTask)((Object)task)).execute(context, env.getExecutionId());
    }
}

