/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Cell;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.Convertor;
import java.util.ListIterator;
import javax.swing.JTable;

public class TableSpeedSearch
extends SpeedSearchBase<JTable> {
    private static final PairFunction<Object, Cell, String> TO_STRING = new PairFunction<Object, Cell, String>(){

        public String fun(Object o, Cell cell) {
            return o == null || o instanceof Boolean ? "" : o.toString();
        }
    };
    private final PairFunction<Object, Cell, String> myToStringConvertor;

    public TableSpeedSearch(JTable table) {
        this(table, TO_STRING);
    }

    public TableSpeedSearch(JTable table, final Convertor<Object, String> toStringConvertor) {
        this(table, new PairFunction<Object, Cell, String>(){

            public String fun(Object o, Cell c) {
                return (String)toStringConvertor.convert(o);
            }
        });
    }

    public TableSpeedSearch(JTable table, PairFunction<Object, Cell, String> toStringConvertor) {
        super(table);
        this.myToStringConvertor = toStringConvertor;
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        boolean tableIsNotEmpty = ((JTable)this.myComponent).getRowCount() != 0 && ((JTable)this.myComponent).getColumnCount() != 0;
        return tableIsNotEmpty && !((JTable)this.myComponent).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected ListIterator<Object> getElementIterator(int startingIndex) {
        return new MyListIterator(startingIndex);
    }

    @Override
    protected int getElementCount() {
        return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        int index = (Integer)element;
        int row = index / ((JTable)this.myComponent).getColumnCount();
        int col = index % ((JTable)this.myComponent).getColumnCount();
        ((JTable)this.myComponent).getSelectionModel().setSelectionInterval(row, row);
        ((JTable)this.myComponent).getColumnModel().getSelectionModel().setSelectionInterval(col, col);
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    @Override
    protected int getSelectedIndex() {
        int row = ((JTable)this.myComponent).getSelectedRow();
        int col = ((JTable)this.myComponent).getSelectedColumn();
        return row > -1 && col > -1 ? row * ((JTable)this.myComponent).getColumnCount() + col : -1;
    }

    @Override
    protected Object[] getAllElements() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    protected String getElementText(Object element) {
        int index = (Integer)element;
        int row = index / ((JTable)this.myComponent).getColumnCount();
        int col = index % ((JTable)this.myComponent).getColumnCount();
        Object value = ((JTable)this.myComponent).getValueAt(row, col);
        return (String)this.myToStringConvertor.fun(value, (Object)new Cell(row, col));
    }

    private class MyListIterator
    implements ListIterator<Object> {
        private int myCursor;

        public MyListIterator(int startingIndex) {
            int total = TableSpeedSearch.this.getElementCount();
            this.myCursor = startingIndex < 0 ? total : startingIndex;
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < TableSpeedSearch.this.getElementCount();
        }

        @Override
        public Object next() {
            return this.myCursor++;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0;
        }

        @Override
        public Object previous() {
            return this.myCursor-- - 1;
        }

        @Override
        public int nextIndex() {
            return this.myCursor;
        }

        @Override
        public int previousIndex() {
            return this.myCursor - 1;
        }

        @Override
        public void remove() {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void set(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }

        @Override
        public void add(Object o) {
            throw new AssertionError((Object)"Not Implemented");
        }
    }
}

