/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;

public final class HttpRequests {
    @NotNull
    public static HttpRequestBuilder request(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/HttpRequests", "request"));
        }
        HttpRequestBuilder httpRequestBuilder = new HttpRequestBuilder(url);
        if (httpRequestBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests", "request"));
        }
        return httpRequestBuilder;
    }

    @NotNull
    public static InputStream getInputStream(@NotNull URLConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/util/HttpRequests", "getInputStream"));
        }
        InputStream inputStream = connection.getInputStream();
        if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
            GZIPInputStream gZIPInputStream;
            block5: {
                try {
                    gZIPInputStream = new GZIPInputStream(inputStream);
                    if (gZIPInputStream != null) break block5;
                }
                catch (IOException e) {
                    inputStream.close();
                    throw e;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests", "getInputStream"));
            }
            return gZIPInputStream;
        }
        InputStream inputStream2 = inputStream;
        if (inputStream2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests", "getInputStream"));
        }
        return inputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T, E extends Throwable> T loadData(@NotNull HttpRequestBuilder requestBuilder, @NotNull ThrowableConvertor<URLConnection, T, E> handler) throws E, IOException {
        if (requestBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestBuilder", "com/intellij/util/HttpRequests", "loadData"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/util/HttpRequests", "loadData"));
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[0], oldClassLoader));
        try {
            Object object;
            URLConnection connection = HttpRequests.openConnection(requestBuilder);
            try {
                object = handler.convert((Object)connection);
            }
            catch (Throwable throwable) {
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
                throw throwable;
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @NotNull
    private static URLConnection openConnection(@NotNull HttpRequestBuilder requestBuilder) throws IOException {
        if (requestBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestBuilder", "com/intellij/util/HttpRequests", "openConnection"));
        }
        int i = 0;
        String url = requestBuilder.url;
        while (i++ < 99) {
            int responseCode;
            URLConnection connection = ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url);
            connection.setConnectTimeout(requestBuilder.connectTimeout);
            connection.setReadTimeout(requestBuilder.readTimeout);
            if (requestBuilder.supportGzip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            connection.setUseCaches(false);
            if (connection instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)connection).getResponseCode()) != 200 && responseCode != 304) {
                url = responseCode == 301 || responseCode == 302 ? connection.getHeaderField("Location") : null;
                if (url == null) {
                    throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
                }
                ((HttpURLConnection)connection).disconnect();
                continue;
            }
            if (url != requestBuilder.url && requestBuilder.effectiveUrlConsumer != null) {
                requestBuilder.effectiveUrlConsumer.consume((Object)url);
            }
            URLConnection uRLConnection = connection;
            if (uRLConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests", "openConnection"));
            }
            return uRLConnection;
        }
        throw new IOException("Infinite redirection");
    }

    public static class HttpRequestBuilder {
        private final String url;
        private int connectTimeout;
        private int readTimeout;
        private Consumer<String> effectiveUrlConsumer;
        private boolean supportGzip;

        private HttpRequestBuilder(@NotNull String url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/HttpRequests$HttpRequestBuilder", "<init>"));
            }
            this.connectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
            this.readTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
            this.supportGzip = true;
            this.url = url;
        }

        @NotNull
        public HttpRequestBuilder connectTimeout(int value) {
            this.connectTimeout = value;
            HttpRequestBuilder httpRequestBuilder = this;
            if (httpRequestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests$HttpRequestBuilder", "connectTimeout"));
            }
            return httpRequestBuilder;
        }

        @NotNull
        public HttpRequestBuilder readTimeout(int value) {
            this.readTimeout = value;
            HttpRequestBuilder httpRequestBuilder = this;
            if (httpRequestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests$HttpRequestBuilder", "readTimeout"));
            }
            return httpRequestBuilder;
        }

        @NotNull
        public HttpRequestBuilder supportGzip(boolean value) {
            this.supportGzip = value;
            HttpRequestBuilder httpRequestBuilder = this;
            if (httpRequestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests$HttpRequestBuilder", "supportGzip"));
            }
            return httpRequestBuilder;
        }

        @NotNull
        public HttpRequestBuilder effectiveUrlConsumer(Consumer<String> value) {
            this.effectiveUrlConsumer = value;
            HttpRequestBuilder httpRequestBuilder = this;
            if (httpRequestBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/HttpRequests$HttpRequestBuilder", "effectiveUrlConsumer"));
            }
            return httpRequestBuilder;
        }

        public <T, E extends Throwable> T get(@NotNull ThrowableConvertor<URLConnection, T, E> handler) throws E, IOException {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/util/HttpRequests$HttpRequestBuilder", "get"));
            }
            return (T)HttpRequests.loadData(this, handler);
        }
    }
}

