/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.Animated;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTableFocusTraversalPolicy;
import com.intellij.util.ui.table.JBListTableModel;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.MouseSuppressor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class JBListTable
extends JPanel {
    protected final JTable myInternalTable;
    private final JBTable mainTable;
    private final Ref<Integer> myLastEditorIndex;
    private MouseEvent myMouseEvent;
    private MyCellEditor myCellEditor;

    public JBListTable(final @NotNull JTable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/ui/table/JBListTable", "<init>"));
        }
        super(new BorderLayout());
        this.myLastEditorIndex = Ref.create(null);
        this.myInternalTable = t;
        final JBListTableModel model = new JBListTableModel(t.getModel()){

            @Override
            public JBTableRow getRow(int index) {
                return JBListTable.this.getRowAt(index);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return JBListTable.this.isRowEditable(rowIndex);
            }

            @Override
            public void addRow() {
                JBListTable.this.myLastEditorIndex.set(null);
                super.addRow();
            }
        };
        this.mainTable = new JBTable(model){

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
            }

            public void editingCanceled(ChangeEvent e) {
                super.editingCanceled(e);
            }

            protected void processKeyEvent(KeyEvent e) {
                JBListTable.this.myMouseEvent = null;
                if (e.isAltDown()) {
                    super.processKeyEvent(e);
                    return;
                }
                if (e.getKeyCode() == 9) {
                    if (e.getID() == 401) {
                        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        if (e.isShiftDown()) {
                            keyboardFocusManager.focusPreviousComponent((Component)((Object)this));
                        } else {
                            keyboardFocusManager.focusNextComponent((Component)((Object)this));
                        }
                    }
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                JBListTable.this.myMouseEvent = e;
                super.processMouseEvent(e);
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
                        return JBListTable.this.getRowRenderer(t, row, selected, hasFocus);
                    }
                };
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean isDown;
                int row;
                if (e.isAltDown() || e.isMetaDown() || e.isControlDown()) {
                    return false;
                }
                if (e.getKeyCode() == 27 && pressed && (row = this.getSelectedRow()) != -1 && JBListTable.this.isRowEmpty(row)) {
                    int newRow;
                    int count = model.getRowCount();
                    model.removeRow(row);
                    int n = newRow = count == row + 1 ? row - 1 : row;
                    if (0 <= newRow && newRow < model.getRowCount()) {
                        this.setRowSelectionInterval(newRow, newRow);
                    }
                }
                if (e.getKeyCode() == 10) {
                    if (e.getID() == 401) {
                        if (!this.isEditing() && e.getModifiers() == 0) {
                            this.editCellAt(this.getSelectedRow(), this.getSelectedColumn());
                        } else if (this.isEditing()) {
                            TableUtil.stopEditing((JTable)((Object)this));
                            if (e.isControlDown() || e.isMetaDown()) {
                                return false;
                            }
                            row = this.getSelectedRow() + 1;
                            if (row < this.getRowCount()) {
                                this.getSelectionModel().setSelectionInterval(row, row);
                            }
                        } else if (e.isControlDown() || e.isMetaDown()) {
                            return false;
                        }
                    }
                    e.consume();
                    return true;
                }
                if (this.isEditing() && e.getKeyCode() == 9) {
                    if (pressed) {
                        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        if (e.isShiftDown()) {
                            mgr.focusPreviousComponent();
                        } else {
                            mgr.focusNextComponent();
                        }
                    }
                    return true;
                }
                boolean isUp = e.getKeyCode() == 38;
                boolean bl = isDown = e.getKeyCode() == 40;
                if (this.isEditing() && (isUp || isDown) && e.getModifiers() == 0 && e.getID() == 401) {
                    int row2 = this.getSelectedRow();
                    super.processKeyBinding(ks, e, condition, pressed);
                    if (!this.isEditing() && row2 != this.getSelectedRow()) {
                        TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)0);
                        e.consume();
                        return true;
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            public TableCellEditor getCellEditor(int row, int column) {
                JBTableRowEditor editor = JBListTable.this.getRowEditor(row);
                if (editor != null) {
                    editor.setMouseEvent(JBListTable.this.myMouseEvent);
                    editor.prepareEditor(t, row);
                    JBListTable.installPaddingAndBordersForEditors(editor);
                    editor.setFocusCycleRoot(true);
                    editor.setFocusTraversalPolicy(new JBListTableFocusTraversalPolicy(editor));
                    MouseSuppressor.install(editor);
                    JBListTable.this.myCellEditor = new MyCellEditor(editor);
                    return JBListTable.this.myCellEditor;
                }
                JBListTable.this.myCellEditor = null;
                return JBListTable.this.myCellEditor;
            }

            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Object value = this.getValueAt(row, column);
                boolean isSelected = this.isCellSelected(row, column);
                return editor.getTableCellEditorComponent((JTable)((Object)this), value, isSelected, row, column);
            }
        };
        this.mainTable.setStriped(true);
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.mainTable);
    }

    private static void installPaddingAndBordersForEditors(JBTableRowEditor editor) {
        List editors = UIUtil.findComponentsOfType((JComponent)editor, EditorTextField.class);
        for (EditorTextField textField : editors) {
            textField.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
            textField.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        }
    }

    public final JBTable getTable() {
        return this.mainTable;
    }

    protected abstract JComponent getRowRenderer(JTable var1, int var2, boolean var3, boolean var4);

    protected abstract JBTableRowEditor getRowEditor(int var1);

    protected JBTableRow getRowAt(final int row) {
        return new JBTableRow(){

            @Override
            public Object getValueAt(int column) {
                return JBListTable.this.myInternalTable.getValueAt(row, column);
            }
        };
    }

    protected boolean isRowEditable(int row) {
        return true;
    }

    protected boolean isRowEmpty(int row) {
        return false;
    }

    public static JComponent createEditorTextFieldPresentation(Project project, FileType type, String text, boolean selected, boolean focused) {
        JPanel panel = new JPanel(new BorderLayout());
        EditorTextField field = new EditorTextField(text, project, type){

            @Override
            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        field.setFont(font);
        field.addSettingsProvider(EditorSettingsProvider.NO_WHITESPACE);
        if (selected && focused) {
            panel.setBackground(UIUtil.getTableSelectionBackground());
            field.setAsRendererWithSelection(UIUtil.getTableSelectionBackground(), UIUtil.getTableSelectionForeground());
        } else {
            panel.setBackground(UIUtil.getTableBackground());
            if (selected) {
                panel.setBorder((Border)new DottedBorder(UIUtil.getTableForeground()));
            }
        }
        panel.add((Component)((Object)field), "West");
        return panel;
    }

    private class MyCellEditor
    extends AbstractTableCellEditor
    implements Animated {
        JTable curTable;
        private final JBTableRowEditor myEditor;

        public MyCellEditor(JBTableRowEditor editor) {
            this.myEditor = editor;
            this.curTable = null;
        }

        public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, int column) {
            this.curTable = table;
            JPanel p = new JPanel(new BorderLayout()){

                @Override
                public void addNotify() {
                    super.addNotify();
                    int height = (int)this.getPreferredSize().getHeight();
                    if (height > table.getRowHeight(row)) {
                        new RowResizeAnimator(table, row, height, MyCellEditor.this.myEditor, JBListTable.this.myMouseEvent == null ? JBListTable.this.myLastEditorIndex : Ref.create(null)).start();
                    }
                }

                @Override
                public void removeNotify() {
                    if (JBListTable.this.myCellEditor != null) {
                        JBListTable.this.myCellEditor.saveFocusIndex();
                    }
                    super.removeNotify();
                    new RowResizeAnimator(table, row, table.getRowHeight(), null, JBListTable.this.myMouseEvent == null ? JBListTable.this.myLastEditorIndex : Ref.create(null)).start();
                }
            };
            p.add((Component)this.myEditor, "Center");
            p.setFocusable(false);
            return p;
        }

        public Object getCellEditorValue() {
            return this.myEditor.getValue();
        }

        public boolean stopCellEditing() {
            this.saveFocusIndex();
            return super.stopCellEditing();
        }

        private void removeEmptyRow() {
            int row = this.curTable.getSelectedRow();
            if (row != -1 && JBListTable.this.isRowEmpty(row)) {
                JBListTableModel model = (JBListTableModel)this.curTable.getModel();
                int count = model.getRowCount();
                model.removeRow(row);
                int newRow = count == row + 1 ? row - 1 : row;
                this.curTable.setRowSelectionInterval(newRow, newRow);
            }
        }

        public void saveFocusIndex() {
            JComponent[] components = this.myEditor.getFocusableComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].hasFocus()) continue;
                JBListTable.this.myLastEditorIndex.set((Object)i);
                break;
            }
        }

        public void cancelCellEditing() {
            this.saveFocusIndex();
            super.cancelCellEditing();
        }
    }

    private static class RowResizeAnimator
    extends Thread {
        private final JTable myTable;
        private final int myRow;
        private final JScrollPane myScrollPane;
        private int neededHeight;
        private final JBTableRowEditor myEditor;
        private final Ref<Integer> myIndex;
        private int step;
        private int currentHeight;

        private RowResizeAnimator(JTable table, int row, int height, JBTableRowEditor editor, @NotNull Ref<Integer> index) {
            if (index == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/util/ui/table/JBListTable$RowResizeAnimator", "<init>"));
            }
            super("Row Animator");
            this.step = 5;
            this.myTable = table;
            this.myRow = row;
            this.neededHeight = height;
            this.myEditor = editor;
            this.myIndex = index;
            this.currentHeight = this.myTable.getRowHeight(this.myRow);
            this.myScrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myTable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            boolean exitEditing;
            block8: {
                exitEditing = this.currentHeight > this.neededHeight;
                try {
                    int index;
                    RowResizeAnimator.sleep(50L);
                    JScrollBar bar = this.myScrollPane.getVerticalScrollBar();
                    if (bar == null || !bar.isVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RowResizeAnimator.this.myScrollPane.setVerticalScrollBarPolicy(21);
                            }
                        });
                        RowResizeAnimator.sleep(15L);
                    }
                    while (this.currentHeight != this.neededHeight) {
                        this.currentHeight = Math.abs(this.currentHeight - this.neededHeight) < this.step ? this.neededHeight : (this.currentHeight += this.currentHeight < this.neededHeight ? this.step : -this.step);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RowResizeAnimator.this.myTable.setRowHeight(RowResizeAnimator.this.myRow, RowResizeAnimator.this.currentHeight);
                            }
                        });
                        RowResizeAnimator.sleep(15L);
                    }
                    if (this.myEditor == null) break block8;
                    JComponent[] components = this.myEditor.getFocusableComponents();
                    JComponent focus = null;
                    if (this.myIndex.get() != null && 0 <= (index = ((Integer)this.myIndex.get()).intValue()) && index < components.length) {
                        focus = components[index];
                    }
                    if (focus == null) {
                        focus = this.myEditor.getPreferredFocusedComponent();
                    }
                    if (focus == null) break block8;
                    focus.requestFocus();
                }
                catch (InterruptedException interruptedException) {
                    SwingUtilities.invokeLater(new Runnable(exitEditing){
                        final /* synthetic */ boolean val$exitEditing;
                        {
                            this.val$exitEditing = bl;
                        }

                        @Override
                        public void run() {
                            TableUtil.scrollSelectionToVisible((JTable)RowResizeAnimator.this.myTable);
                            if (this.val$exitEditing && !RowResizeAnimator.this.myTable.isEditing()) {
                                RowResizeAnimator.this.myScrollPane.setVerticalScrollBarPolicy(20);
                            }
                        }
                    });
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

