/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.RefPainter;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)"Vcs.Log");
    private static final String STANDARD_LAYER = "Standard";
    private static final String MESSAGE_LAYER = "Message";
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final RefsPanel myRefsPanel;
    @NotNull
    private final DataPanel myCommitDetailsPanel;
    @NotNull
    private final MessagePanel myMessagePanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private VisiblePack myDataPack;
    @Nullable
    private VcsFullCommitDetails myCurrentCommitDetails;

    DetailsPanel(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogGraphTable graphTable, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePack initialDataPack) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        this.myLogDataHolder = logDataHolder;
        this.myGraphTable = graphTable;
        this.myDataPack = initialDataPack;
        this.myRefsPanel = new RefsPanel(colorManager);
        this.myCommitDetailsPanel = new DataPanel(logDataHolder.getProject());
        this.myScrollPane = new JBScrollPane(20, 31);
        JPanel content = new JPanel((LayoutManager)new MigLayout("flowy, ins 0, hidemode 3, gapy 0")){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = DetailsPanel.this.myScrollPane.getViewport().getWidth() - 5;
                return size;
            }
        };
        content.setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setViewportView(content);
        content.add((Component)this.myRefsPanel, "");
        content.add((Component)this.myCommitDetailsPanel, "");
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), logDataHolder, 300){

            public Color getBackground() {
                return DetailsPanel.getDetailsBackground();
            }
        };
        this.myLoadingPanel.add((Component)this.myScrollPane);
        this.myMessagePanel = new MessagePanel();
        this.setLayout(new CardLayout());
        this.add((Component)this.myLoadingPanel, STANDARD_LAYER);
        this.add((Component)((Object)this.myMessagePanel), MESSAGE_LAYER);
        this.showMessage("No commits selected");
    }

    @Override
    public Color getBackground() {
        return DetailsPanel.getDetailsBackground();
    }

    private static Color getDetailsBackground() {
        return UIUtil.getTableBackground();
    }

    void updateDataPack(@NotNull VisiblePack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent notUsed) {
        if (notUsed != null && notUsed.getValueIsAdjusting()) {
            return;
        }
        VcsFullCommitDetails newCommitDetails = null;
        int[] rows = this.myGraphTable.getSelectedRows();
        if (rows.length < 1) {
            this.showMessage("No commits selected");
        } else if (rows.length > 1) {
            this.showMessage("Several commits selected");
        } else {
            ((CardLayout)this.getLayout()).show(this, STANDARD_LAYER);
            int row = rows[0];
            GraphTableModel tableModel = (GraphTableModel)this.myGraphTable.getModel();
            Hash hash = tableModel.getHashAtRow(row);
            VcsFullCommitDetails commitData = (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(row, tableModel);
            if (commitData == null || hash == null) {
                this.showMessage("No commits selected");
                return;
            }
            if (commitData instanceof LoadingDetails) {
                this.myLoadingPanel.startLoading();
                this.myCommitDetailsPanel.setData(null);
                this.myRefsPanel.setRefs(Collections.<VcsRef>emptyList());
            } else {
                this.myLoadingPanel.stopLoading();
                this.myCommitDetailsPanel.setData(commitData);
                this.myRefsPanel.setRefs(this.sortRefs(hash, commitData.getRoot()));
                newCommitDetails = commitData;
            }
            List<String> branches = null;
            if (!(commitData instanceof LoadingDetails)) {
                branches = this.myLogDataHolder.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), hash);
            }
            this.myCommitDetailsPanel.setBranches(branches);
            if (!Comparing.equal((Object)this.myCurrentCommitDetails, (Object)newCommitDetails)) {
                this.myCurrentCommitDetails = newCommitDetails;
                this.myScrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    private void showMessage(String text) {
        this.myLoadingPanel.stopLoading();
        ((CardLayout)this.getLayout()).show(this, MESSAGE_LAYER);
        this.myMessagePanel.setText(text);
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(hash);
        List list = ContainerUtil.sorted(refs, (Comparator)this.myLogDataHolder.getLogProvider(root).getReferenceManager().getComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        return list;
    }

    private static class MessagePanel
    extends NonOpaquePanel {
        private final JLabel myLabel = new JLabel();

        MessagePanel() {
            super((LayoutManager)new BorderLayout());
            this.myLabel.setForeground(UIUtil.getInactiveTextColor());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(0);
            this.add(this.myLabel);
        }

        void setText(String text) {
            this.myLabel.setText(text);
        }

        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }

    private static class SingleRefPanel
    extends JPanel {
        @NotNull
        private final RefPainter myRefPainter;
        @NotNull
        private VcsRef myRef;

        SingleRefPanel(@NotNull RefPainter refPainter, @NotNull VcsRef ref) {
            if (refPainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refPainter", "com/intellij/vcs/log/ui/frame/DetailsPanel$SingleRefPanel", "<init>"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/ui/frame/DetailsPanel$SingleRefPanel", "<init>"));
            }
            this.myRefPainter = refPainter;
            this.myRef = ref;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myRefPainter.draw((Graphics2D)g, Collections.singleton(this.myRef), 0, this.getWidth());
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = this.myRefPainter.getComponentWidth(this.myRef.getName(), this.getFontMetrics(RefPainter.DEFAULT_FONT));
            return new Dimension(width, 26);
        }
    }

    private static class RefsPanel
    extends JPanel {
        @NotNull
        private final RefPainter myRefPainter;
        @NotNull
        private List<VcsRef> myRefs;

        RefsPanel(@NotNull VcsLogColorManager colorManager) {
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "<init>"));
            }
            super(new FlowLayout(3, 0, 2));
            this.myRefPainter = new RefPainter(colorManager, false);
            this.myRefs = Collections.emptyList();
            this.setOpaque(false);
        }

        void setRefs(@NotNull List<VcsRef> refs) {
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "setRefs"));
            }
            this.removeAll();
            this.myRefs = refs;
            for (VcsRef ref : refs) {
                this.add(new SingleRefPanel(this.myRefPainter, ref));
            }
            this.setVisible(!this.myRefs.isEmpty());
            this.revalidate();
            this.repaint();
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }

    private static class DataPanel
    extends JEditorPane {
        @NotNull
        private final Project myProject;
        @Nullable
        private String myBranchesText;
        private String myMainText;

        DataPanel(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "<init>"));
            }
            super("text/html", "");
            this.myBranchesText = null;
            this.setEditable(false);
            this.myProject = project;
            this.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.setOpaque(false);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.myMainText = null;
            } else {
                String body = this.getMessageText(commit);
                String header = ((Hash)commit.getId()).toShortString() + " " + DataPanel.getAuthorText(commit);
                this.myMainText = header + "<br/>" + body;
            }
            this.update();
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranchesText = branches == null ? null : StringUtil.join(branches, (String)", ");
            this.update();
        }

        private void update() {
            if (this.myMainText == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + this.myMainText + "<br/>" + "<br/>" + "<i>Contained in branches:</i> " + (this.myBranchesText == null ? "<i>loading...</i>" : this.myBranchesText) + "</body></html>");
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = Math.max(size.height, 4 * this.getFontMetrics(this.getFont()).getHeight());
            return size;
        }

        private String getMessageText(VcsFullCommitDetails commit) {
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            return "<b>" + IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject) + "</b>" + IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description);
        }

        private static String getAuthorText(VcsFullCommitDetails commit) {
            String authorText = commit.getAuthor().getName() + " at " + DateFormatUtil.formatDateTime((long)commit.getAuthorTime());
            if (!commit.getAuthor().equals(commit.getCommitter())) {
                String commitTime = commit.getAuthorTime() != commit.getCommitTime() ? " at " + DateFormatUtil.formatDateTime((long)commit.getCommitTime()) : "";
                authorText = authorText + " (committed by " + commit.getCommitter().getName() + commitTime + ")";
            } else if (commit.getAuthorTime() != commit.getCommitTime()) {
                authorText = authorText + " (committed at " + DateFormatUtil.formatDateTime((long)commit.getCommitTime()) + ")";
            }
            return authorText;
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }
}

