/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.jsonProtocol.RequestWithResponse;
import org.jetbrains.rpc.CommandCallbackWithResponse;
import org.jetbrains.rpc.CommandCallbackWithoutResponse;
import org.jetbrains.rpc.CommandSender;
import org.jetbrains.rpc.ErrorConsumer;
import org.jetbrains.rpc.MessageManager;
import org.jetbrains.rpc.NestedCommandCallbackWithResponse;
import org.jetbrains.rpc.ResultReader;

public abstract class MessageHandler<INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE, ERROR_DETAILS>
implements MessageManager.Handler<Request, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE, ERROR_DETAILS>,
ResultReader<SUCCESS_RESPONSE>,
CommandSender<ERROR_DETAILS> {
    private final AtomicInteger currentSequence = new AtomicInteger();
    protected final MessageManager<Request, INCOMING, INCOMING_WITH_SEQ, SUCCESS_RESPONSE, ERROR_DETAILS> messageManager = new MessageManager(this);

    protected MessageHandler() {
    }

    public void cancelWaitingRequests() {
        this.messageManager.cancelWaitingRequests();
    }

    public void closed() {
        this.messageManager.closed();
    }

    @Override
    public final int getUpdatedSequence(Request message) {
        int id = this.currentSequence.incrementAndGet();
        message.finalize(id);
        return id;
    }

    @Override
    public final ActionCallback send(Request message) {
        CommandCallbackWithoutResponse callback = new CommandCallbackWithoutResponse();
        this.messageManager.send(message, callback);
        return callback.callback;
    }

    @Override
    public final <RESULT, TRANSFORMED_RESULT> AsyncResult<TRANSFORMED_RESULT> send(@NotNull RequestWithResponse message, @NotNull Function<RESULT, TRANSFORMED_RESULT> transform) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        return this.send(message, transform, null);
    }

    @Override
    public final <RESULT, TRANSFORMED_RESULT> AsyncResult<TRANSFORMED_RESULT> send(@NotNull RequestWithResponse message, @NotNull Function<RESULT, TRANSFORMED_RESULT> transform, @Nullable ErrorConsumer<AsyncResult<TRANSFORMED_RESULT>, ERROR_DETAILS> errorConsumer) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        CommandCallbackWithResponse callback = new CommandCallbackWithResponse(message.getMethodName(), transform, errorConsumer);
        this.messageManager.send(message, callback);
        return (AsyncResult)callback.callback;
    }

    @Override
    public final <RESULT, TRANSFORMED_RESULT> void send(@NotNull AsyncResult<TRANSFORMED_RESULT> result, @NotNull RequestWithResponse message, @NotNull Function<RESULT, TRANSFORMED_RESULT> transform) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (transform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transform", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        this.messageManager.send(message, new CommandCallbackWithResponse(result, message.getMethodName(), transform, null));
    }

    @Override
    public final <RESULT, TRANSFORMED_RESULT> AsyncResult<TRANSFORMED_RESULT> send(@NotNull RequestWithResponse message, @NotNull PairConsumer<RESULT, AsyncResult<TRANSFORMED_RESULT>> consumer) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        return this.send((AsyncResult<TRANSFORMED_RESULT>)new AsyncResult(), message, consumer);
    }

    @Override
    public final <RESULT, TRANSFORMED_RESULT> AsyncResult<TRANSFORMED_RESULT> send(@NotNull AsyncResult<TRANSFORMED_RESULT> result, @NotNull RequestWithResponse message, @NotNull PairConsumer<RESULT, AsyncResult<TRANSFORMED_RESULT>> consumer) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        this.messageManager.send(message, new NestedCommandCallbackWithResponse(result, message.getMethodName(), consumer, null));
        return result;
    }

    @Override
    public final <RESULT, TRANSFORMED_RESULT> AsyncResult<TRANSFORMED_RESULT> send(@NotNull AsyncResult<TRANSFORMED_RESULT> result, @NotNull RequestWithResponse message, @NotNull PairConsumer<RESULT, AsyncResult<TRANSFORMED_RESULT>> consumer, @Nullable ErrorConsumer<AsyncResult<TRANSFORMED_RESULT>, ERROR_DETAILS> errorConsumer) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/rpc/MessageHandler", "send"));
        }
        this.messageManager.send(message, new NestedCommandCallbackWithResponse(result, message.getMethodName(), consumer, errorConsumer));
        return result;
    }
}

