/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.execution.ParametersListUtil;
import icons.MavenIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenEditGoalDialog;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenBeforeRunTask;
import org.jetbrains.idea.maven.tasks.TasksBundle;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenBeforeRunTasksProvider
extends BeforeRunTaskProvider<MavenBeforeRunTask> {
    public static final Key<MavenBeforeRunTask> ID = Key.create((String)"Maven.BeforeRunTask");
    private final Project myProject;

    public MavenBeforeRunTasksProvider(Project project) {
        this.myProject = project;
    }

    public Key<MavenBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return TasksBundle.message("maven.tasks.before.run.empty", new Object[0]);
    }

    public Icon getIcon() {
        return MavenIcons.MavenLogo;
    }

    @Nullable
    public Icon getTaskIcon(MavenBeforeRunTask task) {
        return MavenIcons.MavenLogo;
    }

    public String getDescription(MavenBeforeRunTask task) {
        MavenProject mavenProject = this.getMavenProject(task);
        if (mavenProject == null) {
            return TasksBundle.message("maven.tasks.before.run.empty", new Object[0]);
        }
        String desc = mavenProject.getDisplayName() + ": " + StringUtil.notNullize((String)task.getGoal()).trim();
        return TasksBundle.message("maven.tasks.before.run", desc);
    }

    @Nullable
    private MavenProject getMavenProject(MavenBeforeRunTask task) {
        String pomXmlPath = task.getProjectPath();
        if (StringUtil.isEmpty((String)pomXmlPath)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pomXmlPath);
        if (file == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(this.myProject).findProject(file);
    }

    public boolean isConfigurable() {
        return true;
    }

    public MavenBeforeRunTask createTask(RunConfiguration runConfiguration) {
        return new MavenBeforeRunTask();
    }

    public boolean configureTask(RunConfiguration runConfiguration, MavenBeforeRunTask task) {
        MavenEditGoalDialog dialog = new MavenEditGoalDialog(this.myProject);
        dialog.setTitle(TasksBundle.message("maven.tasks.select.goal.title", new Object[0]));
        if (task.getGoal() == null) {
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
            List<MavenProject> rootProjects = projectsManager.getRootProjects();
            if (rootProjects.size() > 0) {
                dialog.setSelectedMavenProject(rootProjects.get(0));
            } else {
                dialog.setSelectedMavenProject(null);
            }
        } else {
            dialog.setGoals(task.getGoal());
            MavenProject mavenProject = this.getMavenProject(task);
            if (mavenProject != null) {
                dialog.setSelectedMavenProject(mavenProject);
            } else {
                dialog.setSelectedMavenProject(null);
            }
        }
        dialog.show();
        if (!dialog.isOK()) {
            return false;
        }
        task.setProjectPath(dialog.getWorkDirectory() + "/pom.xml");
        task.setGoal(dialog.getGoals());
        return true;
    }

    public boolean canExecuteTask(RunConfiguration configuration, MavenBeforeRunTask task) {
        return task.getGoal() != null && task.getProjectPath() != null;
    }

    public boolean executeTask(final DataContext context, RunConfiguration configuration, ExecutionEnvironment env, final MavenBeforeRunTask task) {
        final Semaphore targetDone = new Semaphore();
        final boolean[] result = new boolean[]{true};
        try {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    final Project project = (Project)CommonDataKeys.PROJECT.getData(context);
                    final MavenProject mavenProject = MavenBeforeRunTasksProvider.this.getMavenProject(task);
                    if (project == null || project.isDisposed() || mavenProject == null) {
                        return;
                    }
                    FileDocumentManager.getInstance().saveAllDocuments();
                    final MavenExplicitProfiles explicitProfiles = MavenProjectsManager.getInstance(project).getExplicitProfiles();
                    final MavenRunner mavenRunner = MavenRunner.getInstance(project);
                    targetDone.down();
                    new Task.Backgroundable(project, TasksBundle.message("maven.tasks.executing", new Object[0]), true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/tasks/MavenBeforeRunTasksProvider$1$1", "run"));
                            }
                            try {
                                MavenRunnerParameters params = new MavenRunnerParameters(true, mavenProject.getDirectory(), ParametersListUtil.parse((String)task.getGoal()), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
                                result[0] = mavenRunner.runBatch(Collections.singletonList(params), null, null, TasksBundle.message("maven.tasks.executing", new Object[0]), indicator);
                            }
                            finally {
                                targetDone.up();
                            }
                        }

                        public boolean shouldStartInBackground() {
                            return MavenRunner.getInstance(project).getSettings().isRunMavenInBackground();
                        }

                        public void processSentToBackground() {
                            MavenRunner.getInstance(project).getSettings().setRunMavenInBackground(true);
                        }
                    }.queue();
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            MavenLog.LOG.error((Throwable)e);
            return false;
        }
        targetDone.waitFor();
        return result[0];
    }
}

