/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;

public class GenerateCoverageReportAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageSuitesBundle currentSuite = coverageDataManager.getCurrentSuitesBundle();
        CoverageEngine coverageEngine = currentSuite.getCoverageEngine();
        ExportToHTMLDialog dialog = coverageEngine.createGenerateReportDialog(project, dataContext, currentSuite);
        dialog.reset();
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.apply();
        coverageEngine.generateReport(project, dataContext, currentSuite);
    }

    public void update(AnActionEvent e) {
        CoverageEngine coverageEngine;
        CoverageSuitesBundle currentSuite;
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        presentation.setVisible(false);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (currentSuite = CoverageDataManager.getInstance(project).getCurrentSuitesBundle()) != null && (coverageEngine = currentSuite.getCoverageEngine()).isReportGenerationAvailable(project, dataContext, currentSuite)) {
            presentation.setEnabled(true);
            presentation.setVisible(true);
        }
    }
}

