/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightDisplayLevel {
    private static final Map<HighlightSeverity, HighlightDisplayLevel> ourMap = new HashMap();
    public static final HighlightDisplayLevel GENERIC_SERVER_ERROR_OR_WARNING = new HighlightDisplayLevel(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, HighlightDisplayLevel.createIconByMask(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING));
    public static final HighlightDisplayLevel ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR, HighlightDisplayLevel.createIconByMask(CodeInsightColors.ERRORS_ATTRIBUTES));
    public static final HighlightDisplayLevel WARNING = new HighlightDisplayLevel(HighlightSeverity.WARNING, HighlightDisplayLevel.createIconByMask(CodeInsightColors.WARNINGS_ATTRIBUTES));
    public static final HighlightDisplayLevel DO_NOT_SHOW = new HighlightDisplayLevel(HighlightSeverity.INFORMATION, HighlightDisplayLevel.createIconByMask(new Color(30, 160, 0)));
    @Deprecated
    public static final HighlightDisplayLevel INFO = new HighlightDisplayLevel(HighlightSeverity.INFO, DO_NOT_SHOW.getIcon());
    public static final HighlightDisplayLevel WEAK_WARNING = new HighlightDisplayLevel(HighlightSeverity.WEAK_WARNING, DO_NOT_SHOW.getIcon());
    public static final HighlightDisplayLevel NON_SWITCHABLE_ERROR = new HighlightDisplayLevel(HighlightSeverity.ERROR);
    private Icon myIcon;
    private final HighlightSeverity mySeverity;
    private static final int EMPTY_ICON_DIM = 12;

    @Nullable
    public static HighlightDisplayLevel find(String name) {
        for (Map.Entry<HighlightSeverity, HighlightDisplayLevel> entry : ourMap.entrySet()) {
            HighlightSeverity severity = entry.getKey();
            HighlightDisplayLevel displayLevel = entry.getValue();
            if (!Comparing.strEqual((String)severity.getName(), (String)name)) continue;
            return displayLevel;
        }
        return null;
    }

    public static HighlightDisplayLevel find(HighlightSeverity severity) {
        return ourMap.get(severity);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity, @NotNull Icon icon) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeHighlighting/HighlightDisplayLevel", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/codeHighlighting/HighlightDisplayLevel", "<init>"));
        }
        this(severity);
        this.myIcon = icon;
        ourMap.put(this.mySeverity, this);
    }

    public HighlightDisplayLevel(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeHighlighting/HighlightDisplayLevel", "<init>"));
        }
        this.mySeverity = severity;
    }

    public String toString() {
        return this.mySeverity.toString();
    }

    @NotNull
    public String getName() {
        String string = this.mySeverity.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "getSeverity"));
        }
        return highlightSeverity;
    }

    public static void registerSeverity(@NotNull HighlightSeverity severity, Color renderColor) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeHighlighting/HighlightDisplayLevel", "registerSeverity"));
        }
        Icon severityIcon = HighlightDisplayLevel.createIconByMask(renderColor);
        HighlightDisplayLevel level = ourMap.get(severity);
        if (level == null) {
            new HighlightDisplayLevel(severity, severityIcon);
        } else {
            level.myIcon = severityIcon;
        }
    }

    @NotNull
    private static Icon createIconByMask(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByMask"));
        }
        Icon icon = HighlightDisplayLevel.createIconByMaskFromExtensions(key);
        if (icon != null) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByMask"));
            }
            return icon2;
        }
        TextAttributes defaultAttributes = key.getDefaultAttributes();
        if (defaultAttributes == null) {
            defaultAttributes = TextAttributes.ERASE_MARKER;
        }
        Icon icon3 = HighlightDisplayLevel.createIconByMask(defaultAttributes.getErrorStripeColor());
        if (icon3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByMask"));
        }
        return icon3;
    }

    public static Icon createIconByMaskFromExtensions(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByMaskFromExtensions"));
        }
        for (IconCreator creator : (IconCreator[])Extensions.getExtensions(IconCreator.EXTENSION_POINT_NAME)) {
            Icon icon = creator.createIcon(key);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    public static Icon createIconByMask(Color renderColor) {
        SingleColorIconWithMask singleColorIconWithMask = new SingleColorIconWithMask(renderColor);
        if (singleColorIconWithMask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/HighlightDisplayLevel", "createIconByMask"));
        }
        return singleColorIconWithMask;
    }

    public static class SingleColorIconWithMask
    implements Icon {
        private final Color myColor;

        public SingleColorIconWithMask(Color color) {
            this.myColor = color;
        }

        public Color getColor() {
            return this.myColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(ImageHolder.ourErrorMaskImage, x, y, this.myColor, null);
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }

    public static interface IconCreator {
        public static final ExtensionPointName<IconCreator> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.codeHighlighting.iconCreator");

        public Icon createIcon(@NotNull TextAttributesKey var1);
    }

    public static class ImageHolder {
        public static final Image ourErrorMaskImage = ImageLoader.loadFromResource((String)"/general/errorMask.png");
    }
}

