/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo", "<init>"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo", "<init>"));
        }
        super(element, textRange, icon, updatePass, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> var1);

    public abstract Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> var1);

    @NotNull
    public static List<LineMarkerInfo> merge(@NotNull List<MergeableLineMarkerInfo> markers) {
        if (markers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo", "merge"));
        }
        SmartList result = new SmartList();
        for (int i = 0; i < markers.size(); ++i) {
            MergeableLineMarkerInfo marker = markers.get(i);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i; --k) {
                MergeableLineMarkerInfo current = markers.get(k);
                if (!marker.canMergeWith(current)) continue;
                toMerge.add(current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result.add(marker);
                continue;
            }
            toMerge.add(marker);
            result.add(new MyLineMarkerInfo((List<MergeableLineMarkerInfo>)toMerge));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo", "merge"));
        }
        return smartList;
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public MyLineMarkerInfo(@NotNull List<MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo", "<init>"));
            }
            super(markers.get(0).getElement(), MyLineMarkerInfo.getCommonTextRange(markers), markers.get(0).getCommonIcon(markers), 4, markers.get(0).getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), GutterIconRenderer.Alignment.LEFT);
        }

        private static TextRange getCommonTextRange(List<MergeableLineMarkerInfo> markers) {
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            return TextRange.create((int)startOffset, (int)endOffset);
        }

        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(final @NotNull List<MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo", "getCommonNavigationHandler"));
            }
            return new GutterIconNavigationHandler<PsiElement>(){

                @Override
                public void navigate(final MouseEvent e, PsiElement elt) {
                    ArrayList infos = new ArrayList(markers);
                    Collections.sort(infos, new Comparator<LineMarkerInfo>(){

                        @Override
                        public int compare(LineMarkerInfo o1, LineMarkerInfo o2) {
                            return o1.startOffset - o2.startOffset;
                        }
                    });
                    final JBList list = new JBList(infos);
                    list.setFixedCellHeight(20);
                    list.installCellRenderer(new NotNullFunction<Object, JComponent>(){

                        @NotNull
                        public JComponent fun(Object dom) {
                            if (dom instanceof LineMarkerInfo) {
                                Icon icon = null;
                                GutterIconRenderer renderer = ((LineMarkerInfo)dom).createGutterRenderer();
                                if (renderer != null) {
                                    icon = renderer.getIcon();
                                }
                                Object element = ((LineMarkerInfo)dom).getElement();
                                assert (element != null);
                                String text = StringUtil.first((String)element.getText(), (int)100, (boolean)true).replace('\n', ' ');
                                JBLabel jBLabel = new JBLabel(text, icon, 2);
                                if (jBLabel == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo$1$2", "fun"));
                                }
                                return jBLabel;
                            }
                            JBLabel jBLabel = new JBLabel();
                            if (jBLabel == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo$1$2", "fun"));
                            }
                            return jBLabel;
                        }
                    });
                    JBPopupFactory.getInstance().createListPopupBuilder(list).setItemChoosenCallback(new Runnable(){

                        @Override
                        public void run() {
                            GutterIconNavigationHandler handler;
                            Object value = list.getSelectedValue();
                            if (value instanceof LineMarkerInfo && (handler = ((LineMarkerInfo)value).getNavigationHandler()) != null) {
                                handler.navigate(e, ((LineMarkerInfo)value).getElement());
                            }
                        }
                    }).createPopup().show(new RelativePoint(e));
                }
            };
        }
    }
}

