/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ColorPanel
extends JComponent {
    private final List<ActionListener> myListeners = new CopyOnWriteArrayList<ActionListener>();
    private boolean myEditable;
    private ActionEvent myEvent;
    private Color myColor;

    public ColorPanel() {
        this.setEditable(true);
        this.setMinimumSize(new Dimension(10, 10));
        this.addMouseListener(EventHandler.create(MouseListener.class, this, "onPressed", null, "mousePressed"));
        this.addKeyListener(EventHandler.create(KeyListener.class, this, "onPressed", "keyCode", "keyPressed"));
        this.addFocusListener(EventHandler.create(FocusListener.class, this, "repaint"));
    }

    public void onPressed(int keyCode) {
        if (keyCode == 32) {
            this.onPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPressed() {
        Color color;
        if (this.myEditable && this.isEnabled() && (color = ColorChooser.chooseColor(this, UIBundle.message((String)"color.panel.select.color.dialog.description", (Object[])new Object[0]), this.myColor)) != null) {
            this.setSelectedColor(color);
            if (!this.myListeners.isEmpty() && this.myEvent == null) {
                try {
                    this.myEvent = new ActionEvent(this, 1001, "colorPanelChanged");
                    for (ActionListener listener : this.myListeners) {
                        listener.actionPerformed(this.myEvent);
                    }
                }
                finally {
                    this.myEvent = null;
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor((Color)(this.hasFocus() ? JBColor.BLACK : JBColor.border()));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.myColor != null && this.isEnabled()) {
            g.setColor(this.myColor);
            g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int size;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Font font = this.getFont();
        if (font != null && (size = font.getSize()) > 6) {
            return new Dimension(4 + 2 * size, 4 + size);
        }
        return this.getMinimumSize();
    }

    @Override
    public String getToolTipText() {
        if (this.myColor == null || !this.isEnabled()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder("0x").append(ColorUtil.toHex((Color)this.myColor).toUpperCase());
        if (this.myEditable && this.isEnabled()) {
            buffer.append(" (Click to customize)");
        }
        return buffer.toString();
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.myListeners.remove(actionlistener);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.myListeners.add(actionlistener);
    }

    @Nullable
    public Color getSelectedColor() {
        return this.myColor;
    }

    public void setSelectedColor(@Nullable Color color) {
        this.myColor = color;
        this.repaint();
    }

    public void setEditable(boolean editable) {
        this.myEditable = editable;
        this.setFocusable(editable);
        this.repaint();
    }
}

