/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NewPropertyAction
extends AnAction {
    private final boolean myEnabledForce;

    public NewPropertyAction() {
        this(false);
    }

    public NewPropertyAction(boolean enabledForce) {
        super("New Property", null, AllIcons.General.Add);
        this.myEnabledForce = enabledForce;
    }

    public void actionPerformed(AnActionEvent e) {
        String separator;
        String prefix;
        Project project = NewPropertyAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext());
        if (editor == null || !(editor instanceof ResourceBundleEditor)) {
            return;
        }
        ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)editor;
        String place = e.getPlace();
        if ("StructureViewToolbar".equals(place)) {
            prefix = null;
            separator = null;
        } else {
            ResourceBundleEditorViewElement selectedElement = resourceBundleEditor.getSelectedElementIfOnlyOne();
            if (selectedElement == null) {
                return;
            }
            if (selectedElement instanceof PropertiesPrefixGroup) {
                PropertiesPrefixGroup group = (PropertiesPrefixGroup)selectedElement;
                prefix = group.getPrefix();
                separator = group.getSeparator();
            } else if (selectedElement instanceof ResourceBundlePropertyStructureViewElement || selectedElement instanceof ResourceBundleFileStructureViewElement) {
                prefix = null;
                separator = null;
            } else {
                throw new IllegalStateException("unsupported type: " + selectedElement.getClass());
            }
        }
        ResourceBundle resourceBundle = resourceBundleEditor.getResourceBundle();
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message("new.property.dialog.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("new.property.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)new NewPropertyNameValidator(resourceBundle, prefix, separator));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/NewPropertyAction", "update"));
        }
        if (!this.myEnabledForce) {
            FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(e.getDataContext());
            e.getPresentation().setEnabledAndVisible(editor instanceof ResourceBundleEditor);
        }
    }

    private static class NewPropertyNameValidator
    implements InputValidator {
        @NotNull
        private final ResourceBundle myResourceBundle;
        @Nullable
        private final String myPrefix;
        @Nullable
        private final String mySeparator;

        public NewPropertyNameValidator(@NotNull ResourceBundle resourceBundle, @Nullable String prefix, @Nullable String separator) {
            if (resourceBundle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/editor/NewPropertyAction$NewPropertyNameValidator", "<init>"));
            }
            this.myResourceBundle = resourceBundle;
            this.myPrefix = prefix;
            this.mySeparator = separator;
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        public boolean canClose(String inputString) {
            final String newPropertyName = this.myPrefix == null ? inputString : this.myPrefix + this.mySeparator + inputString;
            for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
                for (String propertyName : propertiesFile.getNamesMap().keySet()) {
                    if (!newPropertyName.equals(propertyName)) continue;
                    Messages.showErrorDialog((String)("Can't add new property. Property with key '" + newPropertyName + "' already exists."), (String)"New Property");
                    return false;
                }
            }
            final PropertiesFile defaultPropertiesFile = this.myResourceBundle.getDefaultPropertiesFile();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                        @Override
                        public void run() {
                            defaultPropertiesFile.addProperty(newPropertyName, "");
                        }
                    });
                }
            });
            return true;
        }
    }
}

