/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.FilterFilePathStrings;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.EmptyChangelistBuilder;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.MoveRenameReplaceCheck;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnFileSystemListener;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.rollback.ChangesAfterPathComparator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public String getRollbackOperationName() {
        return SvnBundle.message("action.name.revert", new Object[0]);
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "rollbackChanges"));
        }
        listener.indeterminate();
        SvnChangeProvider changeProvider = (SvnChangeProvider)this.mySvnVcs.getChangeProvider();
        Collection<List<Change>> collections = SvnUtil.splitChangesIntoWc(this.mySvnVcs, changes);
        for (List<Change> collection : collections) {
            ArrayList<Change> innerChanges = new ArrayList<Change>(collection);
            Collections.sort(innerChanges, ChangesAfterPathComparator.getInstance());
            this.rollbackGroupForWc(innerChanges, exceptions, listener, changeProvider);
        }
    }

    private void rollbackGroupForWc(List<Change> changes, final List<VcsException> exceptions, final RollbackProgressListener listener, SvnChangeProvider changeProvider) {
        UnversionedAndNotTouchedFilesGroupCollector collector = new UnversionedAndNotTouchedFilesGroupCollector();
        ChangesChecker checker = new ChangesChecker(changeProvider, collector);
        checker.gather(changes);
        exceptions.addAll(checker.getExceptions());
        ProgressTracker revertHandler = new ProgressTracker(){

            public void consume(ProgressEvent event) {
                File file;
                if (event.getAction() == EventAction.REVERT && (file = event.getFile()) != null) {
                    listener.accept(file);
                }
                if (event.getAction() == EventAction.FAILED_REVERT) {
                    exceptions.add(new VcsException("Revert failed"));
                }
            }

            @Override
            public void checkCancelled() {
                listener.checkCanceled();
            }
        };
        ArrayList<CopiedAsideInfo> fromToModified = new ArrayList<CopiedAsideInfo>();
        HashMap properties = ContainerUtil.newHashMap();
        this.moveRenamesToTmp(exceptions, fromToModified, properties, collector);
        Reverter reverter = new Reverter(this.mySvnVcs, revertHandler, exceptions);
        reverter.revert(checker.getForAdds(), true);
        reverter.revert(checker.getForDeletes(), true);
        List<File> edits = checker.getForEdits();
        reverter.revert(edits.toArray(new File[edits.size()]), false);
        this.moveGroup(exceptions, fromToModified, properties);
        List<Couple<File>> toBeDeleted = collector.getToBeDeleted();
        for (Couple<File> pair : toBeDeleted) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    private void moveRenamesToTmp(List<VcsException> exceptions, List<CopiedAsideInfo> fromToModified, final Map<File, PropertiesMap> properties, final UnversionedAndNotTouchedFilesGroupCollector collector) {
        Map<File, ThroughRenameInfo> fromTo = collector.getFromTo();
        try {
            File tmp = FileUtil.createTempDirectory((String)"forRename", (String)"");
            PropertyConsumer handler = new PropertyConsumer(){

                @Override
                public void handleProperty(File path, PropertyData property) throws SVNException {
                    ThroughRenameInfo info = collector.findToFile((FilePath)new FilePathImpl(path, path.isDirectory()), null);
                    if (info != null) {
                        if (!properties.containsKey(info.getTo())) {
                            properties.put(info.getTo(), new PropertiesMap());
                        }
                        ((PropertiesMap)((Object)properties.get(info.getTo()))).put(property.getName(), property.getValue());
                    }
                }

                @Override
                public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
                }

                @Override
                public void handleProperty(long revision, PropertyData property) throws SVNException {
                }
            };
            for (Map.Entry<File, ThroughRenameInfo> entry : fromTo.entrySet()) {
                File source = entry.getKey();
                ThroughRenameInfo info = entry.getValue();
                if (info.isVersioned()) {
                    this.mySvnVcs.getFactory(source).createPropertyClient().list(SvnTarget.fromFile((File)source), SVNRevision.WORKING, Depth.EMPTY, handler);
                }
                if (source.isDirectory()) {
                    if (FileUtil.filesEqual((File)info.getTo(), (File)info.getFirstTo())) continue;
                    fromToModified.add(new CopiedAsideInfo(info.getParentImmediateReverted(), info.getTo(), info.getFirstTo(), null));
                    continue;
                }
                File tmpFile = FileUtil.createTempFile((File)tmp, (String)source.getName(), (String)"", (boolean)false);
                tmpFile.mkdirs();
                FileUtil.delete((File)tmpFile);
                FileUtil.copy((File)source, (File)tmpFile);
                fromToModified.add(new CopiedAsideInfo(info.getParentImmediateReverted(), info.getTo(), info.getFirstTo(), tmpFile));
            }
        }
        catch (IOException e) {
            exceptions.add(new VcsException((Throwable)e));
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    private void moveGroup(final List<VcsException> exceptions, List<CopiedAsideInfo> fromTo, Map<File, PropertiesMap> properties) {
        Collections.sort(fromTo, new Comparator<CopiedAsideInfo>(){

            @Override
            public int compare(CopiedAsideInfo o1, CopiedAsideInfo o2) {
                return FileUtil.compareFiles((File)o1.getTo(), (File)o2.getTo());
            }
        });
        for (CopiedAsideInfo info : fromTo) {
            if (!info.getParentImmediateReverted().exists()) continue;
            try {
                File root;
                File from = info.getFrom();
                final File target = info.getTo();
                if (from != null && !FileUtil.filesEqual((File)from, (File)target) && !target.exists()) {
                    SvnFileSystemListener.moveFileWithSvn(this.mySvnVcs, from, target);
                }
                if ((root = info.getTmpPlace()) == null) continue;
                if (!root.isDirectory()) {
                    if (target.exists()) {
                        FileUtil.copy((File)root, (File)target);
                        continue;
                    }
                    FileUtil.rename((File)root, (File)target);
                    continue;
                }
                FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

                    public boolean process(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String relativePath = FileUtil.getRelativePath((String)root.getPath(), (String)file.getPath(), (char)File.separatorChar);
                        File newFile = new File(target, relativePath);
                        newFile.getParentFile().mkdirs();
                        try {
                            if (target.exists()) {
                                FileUtil.copy((File)file, (File)newFile);
                            } else {
                                FileUtil.rename((File)file, (File)newFile);
                            }
                        }
                        catch (IOException e) {
                            exceptions.add(new VcsException((Throwable)e));
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        this.applyProperties(properties, exceptions);
    }

    private void applyProperties(Map<File, PropertiesMap> propertiesMap, List<VcsException> exceptions) {
        for (Map.Entry<File, PropertiesMap> entry : propertiesMap.entrySet()) {
            File file = entry.getKey();
            try {
                this.mySvnVcs.getFactory(file).createPropertyClient().setProperties(file, entry.getValue());
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> filePaths, List<VcsException> exceptions, RollbackProgressListener listener) {
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            listener.accept(file);
            try {
                this.revertFileOrDir(file);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            catch (SVNException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
    }

    private void revertFileOrDir(File file) throws SVNException, VcsException {
        Info info = this.mySvnVcs.getInfo(file);
        if (info != null) {
            if (info.isFile()) {
                this.doRevert(file, false);
            } else if ("add".equals(info.getSchedule())) {
                this.doRevert(file, true);
            } else {
                boolean is17OrGreater = this.is17OrGreaterCopy(file, info);
                if (is17OrGreater) {
                    this.doRevert(file, true);
                } else {
                    this.mySvnVcs.getSvnKitManager().createUpdateClient().doUpdate(file, SVNRevision.HEAD, true);
                }
            }
        } else {
            throw new VcsException("Can not get 'svn info' for " + file.getPath());
        }
    }

    private void doRevert(@NotNull File path, boolean recursive) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment", "doRevert"));
        }
        this.mySvnVcs.getFactory(path).createRevertClient().revert(new File[]{path}, Depth.allOrFiles(recursive), null);
    }

    private boolean is17OrGreaterCopy(File file, Info info) throws VcsException {
        RootsToWorkingCopies copies = this.mySvnVcs.getRootsToWorkingCopies();
        WorkingCopy copy = copies.getMatchingCopy(info.getURL());
        if (copy == null) {
            WorkingCopyFormat format = this.mySvnVcs.getWorkingCopyFormat(file);
            return format.isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
        }
        return copy.is17Copy();
    }

    private static class ChangesChecker {
        private final SuperfluousRemover myForAdds;
        private final SuperfluousRemover myForDeletes;
        private final List<File> myForEdits;
        private final SvnChangeProvider myChangeProvider;
        private final UnversionedAndNotTouchedFilesGroupCollector myCollector;
        private final List<VcsException> myExceptions;

        private ChangesChecker(SvnChangeProvider changeProvider, UnversionedAndNotTouchedFilesGroupCollector collector) {
            this.myChangeProvider = changeProvider;
            this.myCollector = collector;
            this.myForAdds = new SuperfluousRemover(){

                @Override
                @Nullable
                protected File accept(Change change) {
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (beforeRevision == null || MoveRenameReplaceCheck.check(change)) {
                        return afterRevision.getFile().getIOFile();
                    }
                    return null;
                }
            };
            this.myForDeletes = new SuperfluousRemover(){

                @Override
                @Nullable
                protected File accept(Change change) {
                    ContentRevision beforeRevision = change.getBeforeRevision();
                    ContentRevision afterRevision = change.getAfterRevision();
                    if (afterRevision == null || MoveRenameReplaceCheck.check(change)) {
                        return beforeRevision.getFile().getIOFile();
                    }
                    return null;
                }
            };
            this.myForEdits = new ArrayList<File>();
            this.myExceptions = new ArrayList<VcsException>();
        }

        public void gather(List<Change> changes) {
            TreeMap<String, File> renames = new TreeMap<String, File>();
            HashSet<String> alsoReverted = new HashSet<String>();
            HashMap<String, FilePath> files = new HashMap<String, FilePath>();
            for (Change change : changes) {
                String key;
                ContentRevision beforeRevision = change.getBeforeRevision();
                ContentRevision afterRevision = change.getAfterRevision();
                String string = key = afterRevision == null ? null : FilePathsHelper.convertWithLastSeparator((FilePath)afterRevision.getFile());
                if (MoveRenameReplaceCheck.check(change)) {
                    File beforeFile = beforeRevision.getFile().getIOFile();
                    renames.put(key, beforeFile);
                    files.put(key, afterRevision.getFile());
                    this.myCollector.markRename(beforeFile, afterRevision.getFile().getIOFile());
                    continue;
                }
                if (afterRevision == null) continue;
                alsoReverted.add(key);
            }
            if (!renames.isEmpty()) {
                ArrayList paths = new ArrayList(renames.keySet());
                if (paths.size() > 1) {
                    FilterFilePathStrings.getInstance().doFilter(paths);
                }
                this.myCollector.setRenamesMap(renames);
                this.myCollector.setAlsoReverted(alsoReverted);
                for (String path : paths) {
                    try {
                        this.myChangeProvider.getChanges((FilePath)files.get(path), true, (ChangelistBuilder)this.myCollector);
                    }
                    catch (SVNException e) {
                        this.myExceptions.add(new VcsException((Throwable)e));
                    }
                    catch (SvnBindException e) {
                        this.myExceptions.add(e);
                    }
                }
            }
            for (Change change : changes) {
                ContentRevision afterRevision = change.getAfterRevision();
                boolean checked = this.getAddDelete(this.myForAdds, change);
                if (checked |= this.getAddDelete(this.myForDeletes, change)) continue;
                this.myForEdits.add(afterRevision.getFile().getIOFile());
            }
        }

        private boolean getAddDelete(SuperfluousRemover superfluousRemover, Change change) {
            File file = superfluousRemover.accept(change);
            if (file != null) {
                superfluousRemover.check(file);
                return true;
            }
            return false;
        }

        public File[] getForAdds() {
            return this.convert(this.myForAdds.getParentPaths());
        }

        public File[] getForDeletes() {
            return this.convert(this.myForDeletes.getParentPaths());
        }

        private File[] convert(Collection<File> paths) {
            return paths.toArray(new File[paths.size()]);
        }

        public List<VcsException> getExceptions() {
            return this.myExceptions;
        }

        public List<File> getForEdits() {
            return this.myForEdits;
        }
    }

    private static abstract class SuperfluousRemover {
        private final Set<File> myParentPaths = new HashSet<File>();

        private SuperfluousRemover() {
        }

        @Nullable
        protected abstract File accept(Change var1);

        public void check(File file) {
            Iterator<File> iterator = this.myParentPaths.iterator();
            while (iterator.hasNext()) {
                File parentPath = iterator.next();
                if (VfsUtil.isAncestor((File)parentPath, (File)file, (boolean)true)) {
                    return;
                }
                if (!VfsUtil.isAncestor((File)file, (File)parentPath, (boolean)true)) continue;
                iterator.remove();
                while (iterator.hasNext()) {
                    File innerParentPath = iterator.next();
                    if (!VfsUtil.isAncestor((File)file, (File)innerParentPath, (boolean)true)) continue;
                    iterator.remove();
                }
            }
            this.myParentPaths.add(file);
        }

        public Set<File> getParentPaths() {
            return this.myParentPaths;
        }
    }

    private static class ThroughRenameInfo {
        private final File myParentImmediateReverted;
        private final File myTo;
        private final File myFirstTo;
        private final File myFrom;
        private final boolean myVersioned;

        private ThroughRenameInfo(File parentImmediateReverted, File to, File firstTo, File from, boolean versioned) {
            this.myParentImmediateReverted = parentImmediateReverted;
            this.myTo = to;
            this.myFrom = from;
            this.myVersioned = versioned;
            this.myFirstTo = firstTo;
        }

        public File getFirstTo() {
            return this.myFirstTo;
        }

        public boolean isVersioned() {
            return this.myVersioned;
        }

        public File getParentImmediateReverted() {
            return this.myParentImmediateReverted;
        }

        public File getTo() {
            return this.myTo;
        }

        public File getFrom() {
            return this.myFrom;
        }
    }

    private static class CopiedAsideInfo {
        private final File myParentImmediateReverted;
        private final File myTo;
        private final File myFrom;
        private final File myTmpPlace;

        private CopiedAsideInfo(File parentImmediateReverted, File to, File from, File tmpPlace) {
            this.myParentImmediateReverted = parentImmediateReverted;
            this.myTo = to;
            this.myFrom = from;
            this.myTmpPlace = tmpPlace;
        }

        public File getParentImmediateReverted() {
            return this.myParentImmediateReverted;
        }

        public File getTo() {
            return this.myTo;
        }

        public File getFrom() {
            return this.myFrom;
        }

        public File getTmpPlace() {
            return this.myTmpPlace;
        }

        public String toString() {
            return this.myFrom + " -> " + this.myTo;
        }
    }

    private static class UnversionedAndNotTouchedFilesGroupCollector
    extends EmptyChangelistBuilder {
        private final List<Couple<File>> myToBeDeleted;
        private final Map<File, ThroughRenameInfo> myFromTo = new HashMap<File, ThroughRenameInfo>();
        private TreeMap<String, File> myRenames;
        private Set<String> myAlsoReverted;

        private UnversionedAndNotTouchedFilesGroupCollector() {
            this.myToBeDeleted = new ArrayList<Couple<File>>();
        }

        public void processUnversionedFile(VirtualFile file) {
            this.toFromTo(file);
        }

        private void markRename(@NotNull File beforeFile, @NotNull File afterFile) {
            if (beforeFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFile", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$UnversionedAndNotTouchedFilesGroupCollector", "markRename"));
            }
            if (afterFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFile", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$UnversionedAndNotTouchedFilesGroupCollector", "markRename"));
            }
            this.myToBeDeleted.add((Couple<File>)Couple.of((Object)beforeFile, (Object)afterFile));
        }

        public ThroughRenameInfo findToFile(@NotNull FilePath file, @Nullable File firstTo) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$UnversionedAndNotTouchedFilesGroupCollector", "findToFile"));
            }
            String path = FilePathsHelper.convertPath((FilePath)file);
            if (this.myAlsoReverted.contains(path)) {
                return null;
            }
            NavigableMap<String, File> head = this.myRenames.headMap(path, true);
            if (head == null || head.isEmpty()) {
                return null;
            }
            for (Map.Entry entry : head.descendingMap().entrySet()) {
                if (path.equals(entry.getKey())) {
                    return null;
                }
                if (!path.startsWith((String)entry.getKey())) continue;
                String convertedBase = FileUtil.toSystemIndependentName((String)((String)entry.getKey()));
                String convertedChild = FileUtil.toSystemIndependentName((String)file.getPath());
                String relativePath = FileUtil.getRelativePath((String)convertedBase, (String)convertedChild, (char)'/');
                assert (relativePath != null);
                return new ThroughRenameInfo((File)entry.getValue(), new File((File)entry.getValue(), relativePath), firstTo, file.getIOFile(), firstTo != null);
            }
            return null;
        }

        private void toFromTo(VirtualFile file) {
            FilePathImpl path = new FilePathImpl(file);
            ThroughRenameInfo info = this.findToFile((FilePath)path, null);
            if (info != null) {
                this.myFromTo.put(path.getIOFile(), info);
            }
        }

        private void processChangeImpl(Change change) {
            FilePath after;
            ThroughRenameInfo info;
            if (change.getAfterRevision() != null && (info = this.findToFile(after = change.getAfterRevision().getFile(), change.getBeforeRevision() == null ? null : change.getBeforeRevision().getFile().getIOFile())) != null) {
                this.myFromTo.put(after.getIOFile(), info);
            }
        }

        public void processChange(Change change, VcsKey vcsKey) {
            this.processChangeImpl(change);
        }

        public void processChangeInList(Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
            this.processChangeImpl(change);
        }

        public void processChangeInList(Change change, String changeListName, VcsKey vcsKey) {
            this.processChangeImpl(change);
        }

        public void processIgnoredFile(VirtualFile file) {
            this.toFromTo(file);
        }

        public List<Couple<File>> getToBeDeleted() {
            return this.myToBeDeleted;
        }

        public Map<File, ThroughRenameInfo> getFromTo() {
            return this.myFromTo;
        }

        public void setRenamesMap(TreeMap<String, File> renames) {
            this.myRenames = renames;
        }

        public void setAlsoReverted(Set<String> alsoReverted) {
            this.myAlsoReverted = alsoReverted;
        }
    }

    private static class Reverter {
        @NotNull
        private final SvnVcs myVcs;
        private ProgressTracker myHandler;
        private final List<VcsException> myExceptions;

        private Reverter(@NotNull SvnVcs vcs, ProgressTracker handler, List<VcsException> exceptions) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$Reverter", "<init>"));
            }
            this.myVcs = vcs;
            this.myHandler = handler;
            this.myExceptions = exceptions;
        }

        public void revert(File[] files, boolean recursive) {
            if (files.length == 0) {
                return;
            }
            try {
                this.myVcs.getFactory(files[0]).createRevertClient().revert(files, Depth.allOrEmpty(recursive), this.myHandler);
            }
            catch (VcsException e) {
                this.processRevertError(e);
            }
        }

        private void processRevertError(@NotNull VcsException e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/rollback/SvnRollbackEnvironment$Reverter", "processRevertError"));
            }
            if (e.getCause() instanceof SVNException) {
                SVNException cause = (SVNException)e.getCause();
                if (cause.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                    this.myExceptions.add(e);
                }
            } else {
                this.myExceptions.add(e);
            }
        }
    }
}

