/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;

public class GrChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    public static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor");

    public GrChangeSignatureProcessor(Project project, GrChangeInfoImpl changeInfo) {
        super(project, (ChangeInfo)changeInfo);
    }

    public GrChangeInfoImpl getChangeInfo() {
        return (GrChangeInfoImpl)super.getChangeInfo();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        ChangeSignatureViewDescriptor changeSignatureViewDescriptor = new ChangeSignatureViewDescriptor((PsiMethod)this.getChangeInfo().getMethod());
        if (changeSignatureViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureProcessor", "createUsageViewDescriptor"));
        }
        return changeSignatureViewDescriptor;
    }

    protected void refreshElements(PsiElement[] elements) {
        boolean condition = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition);
        this.getChangeInfo().updateMethod((PsiMethod)elements[0]);
    }

    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflictDescriptions = new MultiMap();
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            MultiMap conflicts = usageProcessor.findConflicts(this.myChangeInfo, refUsages);
            for (PsiElement key : conflicts.keySet()) {
                Collection collection = conflictDescriptions.get((Object)key);
                if (collection.isEmpty()) {
                    collection = new HashSet();
                }
                collection.addAll(conflicts.get((Object)key));
                conflictDescriptions.put((Object)key, collection);
            }
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflictDescriptions);
        HashSet usagesSet = new HashSet(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages((Set)usagesSet);
        if (!conflictDescriptions.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflictDescriptions.values());
            }
            ConflictsDialog dialog = this.prepareConflictsDialog(conflictDescriptions, usagesIn);
            dialog.show();
            if (!dialog.isOK()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        refUsages.set((Object)usagesSet.toArray(new UsageInfo[usagesSet.size()]));
        this.prepareSuccessful();
        return true;
    }
}

