/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import java.util.IdentityHashMap;
import java.util.Map;

public class Macros {
    private static final String CREATE_INTENT = "void macro(Context context, Class activityClass) { new Intent(context, activityClass); }";
    private static final String DEFINE_INNER_CLASS = "void macro(Class $Interface, Void $method, Class $Type, Object $arg, final Statement $f) {    new $Interface() {        public void $method($Type $arg) {            $f.$();        }    };}";
    private static final String INSTALL_CLICK_LISTENER = "void macro(View $view, Statement $f) {    $view.setOnClickListener(new View.OnClickListener() {        @Override        public void onClick(View view) {            $f.$();        }    });}";
    private static final String INSTALL_MENU_ITEM_CLICK = "void macro(MenuItem $menuItem, final Statement $f, final boolean $consume) {    $menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener() {        @Override        public boolean onMenuItemClick(MenuItem menuItem) {            $f.$();            return $consume;        }    });}";
    private static final String INSTALL_ITEM_CLICK_LISTENER = "void macro(ListView $listView, final Statement $f) {    $listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {        @Override        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {            $f.$$();        }    });}";
    private static final String GET_MENU_ITEM = "void macro(Menu $menu, int $id) {    $menu.findItem($id);}";
    private static final String LAUNCH_ACTIVITY = "void macro(Context context, Class activityClass) {    context.startActivity(new Intent(context, activityClass));}";
    private static final String LAUNCH_ACTIVITY_WITH_ARG = "<T extends Serializable> void macro(Context context, Class activityClass, String name, T value) {    context.startActivity(new Intent(context, activityClass).putExtra(name, value));}";
    private static final String FIND_VIEW_BY_ID = "void macro(int $id) { findViewById(R.id.$id);}";
    public static final String FIND_FRAGMENT_BY_TAG = "void macro(void $fragmentManager, int $tag) { $fragmentManager.findFragmentByTag($tag);}";
    public final MultiMatch createIntent;
    public final MultiMatch installClickAndCallMacro;
    public final MultiMatch installItemClickAndCallMacro;
    public final MultiMatch installMenuItemOnGetMenuItemAndLaunchActivityMacro;
    public final MultiMatch defineInnerClassToLaunchActivityMacro;
    public final MultiMatch findViewById;
    public final MultiMatch findFragmentByTag;
    private static Map<Project, Macros> ourProjectToMacros = new IdentityHashMap<Project, Macros>();
    private final Project myProject;

    public static Macros getInstance(Project project) {
        Macros result = ourProjectToMacros.get(project);
        if (result == null) {
            result = new Macros(project);
            ourProjectToMacros.put(project, result);
        }
        return result;
    }

    public MultiMatch createMacro(String methodDefinition) {
        return MultiMatch.create(this.myProject, methodDefinition);
    }

    private PsiMethod getMethodFromText(String definition) {
        return Utilities.createMethodFromText(this.myProject, definition);
    }

    private Macros(Project project) {
        this.myProject = project;
        this.createIntent = this.createMacro(CREATE_INTENT);
        this.findViewById = this.createMacro(FIND_VIEW_BY_ID);
        this.findFragmentByTag = this.createMacro(FIND_FRAGMENT_BY_TAG);
        this.installClickAndCallMacro = this.createMacro(INSTALL_CLICK_LISTENER);
        this.installItemClickAndCallMacro = this.createMacro(INSTALL_ITEM_CLICK_LISTENER);
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro = this.createMacro(INSTALL_MENU_ITEM_CLICK);
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro.addSubMacro("$menuItem", this.getMethodFromText(GET_MENU_ITEM));
        this.installMenuItemOnGetMenuItemAndLaunchActivityMacro.addSubMacro("$f", this.getMethodFromText(LAUNCH_ACTIVITY));
        this.defineInnerClassToLaunchActivityMacro = this.createMacro(DEFINE_INNER_CLASS);
        this.defineInnerClassToLaunchActivityMacro.addSubMacro("$f", this.getMethodFromText(LAUNCH_ACTIVITY_WITH_ARG));
    }
}

