/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.compiler;

import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleCompilerSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final CompilerWorkspaceConfiguration myCompilerConfiguration;
    private final AndroidGradleBuildConfiguration myBuildConfiguration;
    private final GradleSettings myGradleSettings;
    private JCheckBox myParallelBuildCheckBox;
    private HyperlinkLabel myParallelBuildDocHyperlinkLabel;
    private RawCommandLineEditor myVmOptionsEditor;
    private JCheckBox myAutoMakeCheckBox;
    private JBLabel myUseInProcessBuildLabel;
    private JCheckBox myUseInProcessBuildCheckBox;
    private JPanel myContentPanel;
    private RawCommandLineEditor myCommandLineOptionsEditor;
    private HyperlinkLabel myCommandLineOptionsDocHyperlinkLabel;
    private JCheckBox myConfigureOnDemandCheckBox;
    private HyperlinkLabel myConfigureOnDemandDocHyperlinkLabel;
    private final String myDisplayName;

    public GradleCompilerSettingsConfigurable(@NotNull Project project, @NotNull String displayName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "<init>"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "<init>"));
        }
        this.myDisplayName = displayName;
        this.$$$setupUI$$$();
        this.myCompilerConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)project);
        this.myBuildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
        this.myGradleSettings = GradleSettings.getInstance((Project)project);
        if (!AndroidStudioSpecificInitializer.isAndroidStudio()) {
            this.myUseInProcessBuildLabel.setVisible(false);
            this.myUseInProcessBuildCheckBox.setVisible(false);
        }
    }

    @NotNull
    public String getId() {
        if ("gradle.compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "getId"));
        }
        return "gradle.compiler";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.projectsettings.compiler.gradle";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myCompilerConfiguration.PARALLEL_COMPILATION != this.isParallelBuildsEnabled() || !Objects.equal((Object)this.getVmOptions(), (Object)this.myGradleSettings.getGradleVmOptions()) || this.myCompilerConfiguration.MAKE_PROJECT_ON_SAVE != this.isAutoMakeEnabled() || this.myBuildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD != this.isExperimentalBuildEnabled() || this.myBuildConfiguration.USE_CONFIGURATION_ON_DEMAND != this.isConfigurationOnDemandEnabled() || !Objects.equal((Object)this.getCommandLineOptions(), (Object)this.myBuildConfiguration.COMMAND_LINE_OPTIONS);
    }

    public void apply() {
        this.myCompilerConfiguration.PARALLEL_COMPILATION = this.isParallelBuildsEnabled();
        this.myGradleSettings.setGradleVmOptions(this.getVmOptions());
        this.myCompilerConfiguration.MAKE_PROJECT_ON_SAVE = this.isAutoMakeEnabled();
        this.myBuildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD = this.isExperimentalBuildEnabled();
        this.myBuildConfiguration.COMMAND_LINE_OPTIONS = this.getCommandLineOptions();
        this.myBuildConfiguration.USE_CONFIGURATION_ON_DEMAND = this.isConfigurationOnDemandEnabled();
    }

    private boolean isParallelBuildsEnabled() {
        return this.myParallelBuildCheckBox.isSelected();
    }

    private boolean isAutoMakeEnabled() {
        return this.myAutoMakeCheckBox.isSelected();
    }

    private boolean isExperimentalBuildEnabled() {
        return this.myUseInProcessBuildCheckBox.isSelected();
    }

    private boolean isConfigurationOnDemandEnabled() {
        return this.myConfigureOnDemandCheckBox.isSelected();
    }

    @Nullable
    private String getVmOptions() {
        return Strings.emptyToNull((String)this.myVmOptionsEditor.getText().trim());
    }

    @NotNull
    private String getCommandLineOptions() {
        String string = this.myCommandLineOptionsEditor.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "getCommandLineOptions"));
        }
        return string;
    }

    public void reset() {
        this.myParallelBuildCheckBox.setSelected(this.myCompilerConfiguration.PARALLEL_COMPILATION);
        String vmOptions = Strings.nullToEmpty((String)this.myGradleSettings.getGradleVmOptions());
        this.myVmOptionsEditor.setText(vmOptions);
        this.myAutoMakeCheckBox.setSelected(this.myCompilerConfiguration.MAKE_PROJECT_ON_SAVE);
        this.myUseInProcessBuildCheckBox.setSelected(this.myBuildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD);
        this.myConfigureOnDemandCheckBox.setSelected(this.myBuildConfiguration.USE_CONFIGURATION_ON_DEMAND);
        this.myAutoMakeCheckBox.setText("Make project automatically (only works while not running / debugging" + (PowerSaveMode.isEnabled() ? ", disabled in Power Save mode" : "") + ")");
        String commandLineOptions = Strings.nullToEmpty((String)this.myBuildConfiguration.COMMAND_LINE_OPTIONS);
        this.myCommandLineOptionsEditor.setText(commandLineOptions);
        this.myConfigureOnDemandCheckBox.setSelected(this.myBuildConfiguration.USE_CONFIGURATION_ON_DEMAND);
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myParallelBuildDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("This option is in \"incubation\" and should only be used with ", "decoupled projects", ".", "http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects");
        this.myCommandLineOptionsDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("Example: --stacktrace --debug (for more information, please read Gradle's ", "documentation", ".)", "http://www.gradle.org/docs/current/userguide/gradle_command_line.html");
        this.myConfigureOnDemandDocHyperlinkLabel = GradleCompilerSettingsConfigurable.createHyperlinkLabel("This option may speed up builds. This option is in \"incubation.\" Please read Gradle's ", "documentation", ".", "http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:configuration_on_demand");
        this.myVmOptionsEditor = new RawCommandLineEditor();
        this.myVmOptionsEditor.setDialogCaption("Gradle VM Options");
        this.myCommandLineOptionsEditor = new RawCommandLineEditor();
        this.myCommandLineOptionsEditor.setDialogCaption("Command-line Options");
    }

    @NotNull
    private static HyperlinkLabel createHyperlinkLabel(@NotNull String beforeLinkText, @NotNull String linkText, @NotNull String afterLinkText, @NotNull String target) {
        if (beforeLinkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeLinkText", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "createHyperlinkLabel"));
        }
        if (linkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkText", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "createHyperlinkLabel"));
        }
        if (afterLinkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterLinkText", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "createHyperlinkLabel"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "createHyperlinkLabel"));
        }
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkText(beforeLinkText, linkText, afterLinkText);
        label.setHyperlinkTarget(target);
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/GradleCompilerSettingsConfigurable", "createHyperlinkLabel"));
        }
        return hyperlinkLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(19, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(18, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myParallelBuildCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Compile independent modules in parallel (may require larger heap size)");
        jPanel.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myParallelBuildDocHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><b>Note:</b> These settings are used for <b>compiling</b> Gradle-based Android projects.</html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("<html><br></html>");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("VM Options:");
        jPanel.add((Component)jBLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myVmOptionsEditor;
        rawCommandLineEditor.setDialogCaption("Gradle VM Options");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(5, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Example: -Xmx2048m -XX:MaxPermSize=512m ");
        jPanel.add((Component)jBLabel6, new GridConstraints(6, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("<html><br></html>");
        jPanel.add((Component)jBLabel7, new GridConstraints(7, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        this.myAutoMakeCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Make project automatically (only works while not running / debugging)");
        jPanel.add((Component)jCheckBox3, new GridConstraints(11, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myUseInProcessBuildCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand("");
        jCheckBox2.setText("Use in-process build");
        jPanel.add((Component)jCheckBox2, new GridConstraints(13, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("<html><br></html>");
        jPanel.add((Component)jBLabel8, new GridConstraints(12, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("<html><br></html>");
        jPanel.add((Component)jBLabel9, new GridConstraints(15, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        this.myUseInProcessBuildLabel = jBLabel = new JBLabel();
        jBLabel.setText("Faster, and integrated with the \"Gradle Console.\"");
        jPanel.add((Component)jBLabel, new GridConstraints(14, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("<html><br></html>");
        jPanel.add((Component)jBLabel10, new GridConstraints(10, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Command-line Options:");
        jPanel.add((Component)jBLabel11, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor2 = this.myCommandLineOptionsEditor;
        jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(8, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel2 = this.myCommandLineOptionsDocHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel2, new GridConstraints(9, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.myConfigureOnDemandCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Configure on demand");
        jPanel.add((Component)jCheckBox, new GridConstraints(16, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel3 = this.myConfigureOnDemandDocHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel3, new GridConstraints(17, 0, 1, 3, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

