/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.JavaModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.DefaultSdks;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleProjectData
implements Serializable {
    @NotNull
    @NonNls
    private static final String STATE_FILE_NAME = "model_data.bin";
    private static final boolean ENABLED = !Boolean.getBoolean("studio.disable.synccache");
    private static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(File.class, Boolean.class, String.class, Integer.class, Collection.class, Map.class, (Object[])new Class[]{Set.class});
    private static final Logger LOG = Logger.getInstance(AndroidGradleProjectData.class);
    private Map<String, ModuleData> myData = Maps.newHashMap();
    private Map<String, byte[]> myFileChecksums = Maps.newHashMap();
    private String myGradlePluginVersion = "0.14.+";
    private long myLastGradleSyncTimestamp = -1L;

    private AndroidGradleProjectData() {
    }

    public static void removeFrom(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "removeFrom"));
        }
        if (!ENABLED) {
            return;
        }
        try {
            File stateFile = AndroidGradleProjectData.getProjectStateFile(project);
            if (stateFile.isFile()) {
                FileUtil.delete((File)stateFile);
            }
        }
        catch (IOException e) {
            LOG.warn(String.format("Failed to remove state for project %1$s'", project.getName()));
        }
    }

    public static void save(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "save"));
        }
        if (!ENABLED) {
            return;
        }
        boolean cacheSaved = false;
        try {
            AndroidGradleProjectData data = AndroidGradleProjectData.createFrom(project);
            if (data != null) {
                File file = AndroidGradleProjectData.getProjectStateFile(project);
                FileUtil.ensureExists((File)file.getParentFile());
                data.saveTo(file);
                cacheSaved = true;
            }
        }
        catch (IOException e) {
            LOG.info(String.format("Error while saving persistent state from project '%1$s'", project.getName()), (Throwable)e);
        }
        if (!cacheSaved) {
            LOG.info("Failed to generate new cache. Deleting the old one.");
            AndroidGradleProjectData.removeFrom(project);
        }
    }

    @Nullable
    static AndroidGradleProjectData createFrom(@NotNull Project project) throws IOException {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "createFrom"));
        }
        AndroidGradleProjectData data = new AndroidGradleProjectData();
        File rootDirPath = new File(project.getBasePath());
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            JavaGradleFacet javaFacet;
            AndroidGradleFacet gradleFacet;
            ModuleData moduleData = new ModuleData();
            moduleData.myName = module.getName();
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null) {
                IdeaAndroidProject ideaAndroidProject = androidFacet.getIdeaAndroidProject();
                if (ideaAndroidProject != null) {
                    moduleData.myAndroidProject = AndroidGradleProjectData.reproxy(AndroidProject.class, ideaAndroidProject.getDelegate());
                    moduleData.mySelectedVariant = ideaAndroidProject.getSelectedVariant().getName();
                } else {
                    LOG.warn(String.format("Trying to create project data from a not initialized project '%1$s'. Abort.", project.getName()));
                    return null;
                }
            }
            if ((gradleFacet = AndroidGradleFacet.getInstance(module)) != null) {
                IdeaGradleProject ideaGradleProject = gradleFacet.getGradleProject();
                if (ideaGradleProject != null) {
                    data.addFileDependency(rootDirPath, ideaGradleProject.getBuildFile());
                    moduleData.myIdeaGradleProject = ideaGradleProject;
                } else {
                    LOG.warn(String.format("Trying to create project data from a not initialized project '%1$s'. Abort.", project.getName()));
                    return null;
                }
            }
            if ((javaFacet = JavaGradleFacet.getInstance(module)) != null) {
                moduleData.myJavaModel = javaFacet.getJavaModel();
            }
            if (Projects.isGradleProjectModule(module)) {
                data.addFileDependency(rootDirPath, GradleUtil.getGradleBuildFile(module));
                data.addFileDependency(rootDirPath, GradleUtil.getGradleSettingsFile(rootDirPath));
                data.addFileDependency(rootDirPath, new File(rootDirPath, "gradle.properties"));
                data.addFileDependency(rootDirPath, new File(rootDirPath, "local.properties"));
                data.addFileDependency(rootDirPath, AndroidGradleProjectData.getGradleUserSettingsFile());
            }
            data.myData.put(moduleData.myName, moduleData);
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        data.myLastGradleSyncTimestamp = syncState.getLastGradleSyncTimestamp();
        return data;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = System.getProperty("user.home");
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    @NotNull
    private static byte[] createChecksum(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "createChecksum"));
        }
        VirtualFile vf = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        byte[] data = new byte[]{};
        if (vf != null) {
            vf.refresh(false, false);
            if (vf.exists()) {
                data = vf.contentsToByteArray();
            }
        } else if (file.exists()) {
            data = Files.toByteArray((File)file);
        }
        byte[] byArray = Hashing.md5().hashBytes(data).asBytes();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "createChecksum"));
        }
        return byArray;
    }

    public static boolean loadFromDisk(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "loadFromDisk"));
        }
        if (!ENABLED || AndroidGradleProjectData.needsAndroidSdkSync(project)) {
            return false;
        }
        try {
            return AndroidGradleProjectData.doLoadFromDisk(project);
        }
        catch (IOException e) {
            LOG.info(String.format("Error accessing state cache for project '%1$s', sync will be needed.", project.getName()));
        }
        catch (ClassNotFoundException e) {
            LOG.info(String.format("Cannot recover state cache for project '%1$s', sync will be needed.", project.getName()));
        }
        return false;
    }

    private static boolean needsAndroidSdkSync(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "needsAndroidSdkSync"));
        }
        if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
            final File ideSdkPath = DefaultSdks.getDefaultAndroidHome();
            if (ideSdkPath != null) {
                if (AndroidGradleProjectData.needsLPreviewPlatformReset()) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            DefaultSdks.setDefaultAndroidHome(ideSdkPath, DefaultSdks.getDefaultJdk(), project);
                        }
                    });
                    return true;
                }
                try {
                    LocalProperties localProperties = new LocalProperties(project);
                    File projectSdkPath = localProperties.getAndroidSdkPath();
                    return projectSdkPath == null || !FileUtil.filesEqual((File)ideSdkPath, (File)projectSdkPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private static boolean needsLPreviewPlatformReset() {
        for (Sdk sdk : DefaultSdks.getEligibleAndroidSdks()) {
            VirtualFile[] libraryFiles;
            IAndroidTarget target;
            AndroidVersion version;
            AndroidPlatform androidPlatform;
            SdkAdditionalData additionalData = sdk.getSdkAdditionalData();
            if (!(additionalData instanceof AndroidSdkAdditionalData) || (androidPlatform = ((AndroidSdkAdditionalData)additionalData).getAndroidPlatform()) == null || !"L".equals((version = (target = androidPlatform.getTarget()).getVersion()).getApiString()) || version.getApiLevel() != 20 || !version.isPreview()) continue;
            String androidJarPath = target.getPath(1);
            File expectedPath = new File(androidJarPath);
            for (VirtualFile libraryFile : libraryFiles = sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!"android.jar".equals(libraryFile.getName())) continue;
                File actualPath = VfsUtilCore.virtualToIoFile((VirtualFile)libraryFile);
                return !FileUtil.filesEqual((File)expectedPath, (File)actualPath);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean doLoadFromDisk(@NotNull Project project) throws IOException, ClassNotFoundException {
        FileInputStream fin;
        block9: {
            ObjectInputStream ois;
            block8: {
                File dataFile;
                File rootDirPath;
                block7: {
                    boolean bl;
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "doLoadFromDisk"));
                    }
                    fin = null;
                    try {
                        rootDirPath = new File(FileUtil.toSystemDependentName((String)project.getBasePath()));
                        dataFile = AndroidGradleProjectData.getProjectStateFile(project);
                        if (dataFile.exists()) break block7;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        Closeables.close(fin, (boolean)false);
                        throw throwable;
                    }
                    Closeables.close(fin, (boolean)false);
                    return bl;
                }
                fin = new FileInputStream(dataFile);
                ois = new ObjectInputStream(fin);
                AndroidGradleProjectData data = (AndroidGradleProjectData)ois.readObject();
                if (!data.validate(rootDirPath) || !data.applyTo(project)) break block8;
                PostProjectSetupTasksExecutor.getInstance(project).onProjectRestoreFromDisk();
                boolean bl = true;
                Closeables.close((Closeable)ois, (boolean)false);
                Closeables.close((Closeable)fin, (boolean)false);
                return bl;
            }
            Closeables.close((Closeable)ois, (boolean)false);
            break block9;
            {
                catch (Throwable throwable) {
                    Closeables.close((Closeable)ois, (boolean)false);
                    throw throwable;
                }
            }
        }
        Closeables.close((Closeable)fin, (boolean)false);
        return false;
    }

    @NotNull
    private static File getProjectStateFile(@NotNull Project project) throws IOException {
        File buildFolderPath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "getProjectStateFile"));
        }
        Module projectModule = Projects.findGradleProjectModule(project);
        if (projectModule != null && (buildFolderPath = Projects.getBuildFolderPath(projectModule)) != null) {
            File file = new File(buildFolderPath, FileUtil.join((String[])new String[]{"intermediates", STATE_FILE_NAME}));
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "getProjectStateFile"));
            }
            return file;
        }
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir()), FileUtil.join((String[])new String[]{"build", "intermediates", STATE_FILE_NAME}));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "getProjectStateFile"));
        }
        return file;
    }

    @Nullable
    static <T> T reproxy(Type type, T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof InvocationErrorValue) {
            return object;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            if (genericType.getRawType() instanceof Class) {
                Class genericClass = (Class)genericType.getRawType();
                if (Collection.class.isAssignableFrom(genericClass)) {
                    AbstractCollection newCollection;
                    Collection collection = (Collection)object;
                    if (genericClass.isAssignableFrom(ArrayList.class)) {
                        newCollection = Lists.newArrayListWithCapacity((int)collection.size());
                    } else if (genericClass.isAssignableFrom(Set.class)) {
                        newCollection = Sets.newLinkedHashSet();
                    } else {
                        throw new IllegalStateException("Unsupported collection type: " + genericClass.getCanonicalName());
                    }
                    Type argument = genericType.getActualTypeArguments()[0];
                    for (Object item : collection) {
                        newCollection.add(AndroidGradleProjectData.reproxy(argument, item));
                    }
                    return (T)newCollection;
                }
                if (Map.class.isAssignableFrom(genericClass)) {
                    Map map = (Map)object;
                    LinkedHashMap newMap = Maps.newLinkedHashMap();
                    Type keyType = genericType.getActualTypeArguments()[0];
                    Type valueType = genericType.getActualTypeArguments()[1];
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(AndroidGradleProjectData.reproxy(keyType, entry.getKey()), AndroidGradleProjectData.reproxy(valueType, entry.getValue()));
                    }
                    return (T)newMap;
                }
                throw new IllegalStateException("Unsupported generic type: " + genericClass.getCanonicalName());
            }
            throw new IllegalStateException("Unsupported raw type.");
        }
        if (!Proxy.isProxyClass(object.getClass())) {
            return object;
        }
        if (Proxy.getInvocationHandler(object) instanceof WrapperInvocationHandler) {
            return object;
        }
        Class<?>[] interfaces = object.getClass().getInterfaces();
        if (interfaces.length != 1) {
            throw new IllegalStateException("Cannot 'reproxy' a class with multiple interfaces");
        }
        Class<?> clazz = interfaces[0];
        HashMap values = Maps.newHashMap();
        for (Method m : clazz.getMethods()) {
            try {
                Object value;
                if (!Modifier.isPublic(m.getModifiers())) continue;
                try {
                    value = m.invoke(object, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    value = new InvocationErrorValue(e.getCause());
                }
                values.put(m.toGenericString(), AndroidGradleProjectData.reproxy(m.getGenericReturnType(), value));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("A non public method shouldn't have been called.", e);
            }
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new WrapperInvocationHandler(values));
    }

    static boolean isSupported(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "isSupported"));
        }
        return clazz.isPrimitive() || SUPPORTED_TYPES.contains(clazz);
    }

    private void addFileDependency(File rootDirPath, @Nullable VirtualFile vf) throws IOException {
        this.addFileDependency(rootDirPath, vf != null ? VfsUtilCore.virtualToIoFile((VirtualFile)vf) : null);
    }

    private void addFileDependency(File rootDirPath, @Nullable File file) throws IOException {
        if (file == null) {
            return;
        }
        String key = FileUtil.isAncestor((File)rootDirPath, (File)file, (boolean)true) ? FileUtil.getRelativePath((File)rootDirPath, (File)file) : file.getAbsolutePath();
        this.myFileChecksums.put(key, AndroidGradleProjectData.createChecksum(file));
    }

    private boolean validate(@NotNull File rootDir) throws IOException {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/gradle/project/AndroidGradleProjectData", "validate"));
        }
        if (!this.myGradlePluginVersion.equals("0.14.+")) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : this.myFileChecksums.entrySet()) {
            File file = new File(entry.getKey());
            if (!file.isAbsolute()) {
                file = new File(rootDir, file.getPath());
            }
            if (Arrays.equals(entry.getValue(), AndroidGradleProjectData.createChecksum(file))) continue;
            return false;
        }
        return true;
    }

    public boolean applyTo(Project project) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            JavaGradleFacet javaFacet;
            AndroidGradleFacet gradleFacet;
            ModuleData data = this.myData.get(module.getName());
            if (data == null) {
                return false;
            }
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            String moduleFilePath = module.getModuleFilePath();
            if (androidFacet != null) {
                if (data.myAndroidProject != null) {
                    File moduleFile = new File(moduleFilePath);
                    assert (moduleFile.getParent() != null) : moduleFile.getPath();
                    File moduleRootDirPath = moduleFile.getParentFile();
                    IdeaAndroidProject ideaAndroidProject = new IdeaAndroidProject(module.getName(), moduleRootDirPath, data.myAndroidProject, data.mySelectedVariant);
                    androidFacet.setIdeaAndroidProject(ideaAndroidProject);
                } else {
                    return false;
                }
            }
            if ((gradleFacet = AndroidGradleFacet.getInstance(module)) != null) {
                gradleFacet.setGradleProject(data.myIdeaGradleProject);
            }
            if ((javaFacet = JavaGradleFacet.getInstance(module)) == null || data.myJavaModel == null) continue;
            javaFacet.setJavaModel(data.myJavaModel);
        }
        GradleSyncState.getInstance(project).syncSkipped(this.myLastGradleSyncTimestamp);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTo(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            try {
                oos.writeObject(this);
            }
            finally {
                Closeables.close((Closeable)oos, (boolean)false);
            }
        }
        finally {
            Closeables.close((Closeable)fos, (boolean)false);
        }
    }

    Map<String, ModuleData> getModuleData() {
        return this.myData;
    }

    Map<String, byte[]> getFileChecksums() {
        return this.myFileChecksums;
    }

    private static class InvocationErrorValue
    implements Serializable {
        public Throwable exception;

        private InvocationErrorValue(Throwable exception) {
            this.exception = exception;
        }
    }

    static class WrapperInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final Method TO_STRING = WrapperInvocationHandler.getObjectMethod("toString", new Class[0]);
        private static final Method HASHCODE = WrapperInvocationHandler.getObjectMethod("hashCode", new Class[0]);
        private static final Method EQUALS = WrapperInvocationHandler.getObjectMethod("equals", Object.class);
        final Map<String, Object> values;

        WrapperInvocationHandler(@NotNull Map<String, Object> values) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/gradle/project/AndroidGradleProjectData$WrapperInvocationHandler", "<init>"));
            }
            this.values = values;
        }

        @NotNull
        private static Method getObjectMethod(@NotNull String name, Class<?> ... types) {
            Method method;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/AndroidGradleProjectData$WrapperInvocationHandler", "getObjectMethod"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/android/tools/idea/gradle/project/AndroidGradleProjectData$WrapperInvocationHandler", "getObjectMethod"));
            }
            try {
                method = Object.class.getMethod(name, types);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Method should exist in Object", e);
            }
            if (method == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleProjectData$WrapperInvocationHandler", "getObjectMethod"));
            }
            return method;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (method.equals(TO_STRING)) {
                return method.invoke((Object)this, objects);
            }
            if (method.equals(HASHCODE)) {
                return method.invoke((Object)this, objects);
            }
            if (method.equals(EQUALS)) {
                return this.proxyEquals(objects[0]);
            }
            String key = method.toGenericString();
            if (!this.values.containsKey(key)) {
                throw new UnsupportedMethodException("Method " + key + " not found");
            }
            Object value = this.values.get(key);
            if (value instanceof InvocationErrorValue) {
                throw ((InvocationErrorValue)value).exception;
            }
            return value;
        }

        private boolean proxyEquals(Object other) {
            return other != null && Proxy.isProxyClass(other.getClass()) && Proxy.getInvocationHandler(other).equals(this);
        }
    }

    static class ModuleData
    implements Serializable {
        public String myName;
        public IdeaGradleProject myIdeaGradleProject;
        public AndroidProject myAndroidProject;
        public String mySelectedVariant;
        public JavaModel myJavaModel;

        ModuleData() {
        }
    }
}

