/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class StopGradleDaemonsAndSyncHyperlink
extends NotificationHyperlink {
    public StopGradleDaemonsAndSyncHyperlink() {
        super("stopGradleDaemons", "Stop Gradle daemons and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/hyperlink/StopGradleDaemonsAndSyncHyperlink", "execute"));
        }
        String message = "Stopping all Gradle daemons will terminate any running Gradle builds (e.g. from the command line.)\n\nDo you want to continue?";
        String title = "Stop Gradle Daemons";
        int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            try {
                GradleUtil.stopAllGradleDaemons(true);
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
            catch (IOException error) {
                Messages.showErrorDialog((String)("Failed to stop Gradle daemons. Please run 'gradle --stop' from the command line.\n\nCause:\n" + error.getMessage()), (String)title);
            }
        }
    }
}

