/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.startup.AndroidStudioSpecificInitializer;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultSdks {
    private static final Logger LOG = Logger.getInstance(DefaultSdks.class);
    private static final String ERROR_DIALOG_TITLE = "Project SDK Update";

    private DefaultSdks() {
    }

    @Nullable
    public static File getDefaultAndroidHome() {
        String sdkHome = null;
        Sdk sdk = DefaultSdks.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null) {
            return new File(FileUtil.toSystemDependentName((String)sdkHome));
        }
        return null;
    }

    @Nullable
    public static File getDefaultJavaHome() {
        List<Sdk> androidSdks = DefaultSdks.getEligibleAndroidSdks();
        if (androidSdks.isEmpty()) {
            String jdkHomePath;
            Sdk jdk = Jdks.chooseOrCreateJavaSdk();
            if (jdk != null && (jdkHomePath = jdk.getHomePath()) != null) {
                return new File(FileUtil.toSystemDependentName((String)jdkHomePath));
            }
        } else {
            for (Sdk sdk : androidSdks) {
                String jdkHomePath;
                AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
                assert (data != null);
                Sdk jdk = data.getJavaSdk();
                if (jdk == null || (jdkHomePath = jdk.getHomePath()) == null) continue;
                return new File(FileUtil.toSystemDependentName((String)jdkHomePath));
            }
        }
        return null;
    }

    @Nullable
    private static Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = DefaultSdks.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public static void setDefaultJavaHome(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/DefaultSdks", "setDefaultJavaHome"));
        }
        ArrayList sdksToDelete = Lists.newArrayList();
        if (JavaSdk.checkForJdk((File)path)) {
            File canonicalPath = DefaultSdks.resolvePath(path);
            Sdk defaultJdk = DefaultSdks.getDefaultJdk();
            if (defaultJdk != null) {
                DefaultSdks.setJdkPath(defaultJdk, canonicalPath);
                DefaultSdks.updateAllSdks(defaultJdk);
            } else {
                VirtualFile virtualPath = VfsUtil.findFileByIoFile((File)canonicalPath, (boolean)true);
                if (virtualPath != null) {
                    defaultJdk = DefaultSdks.createJdk(virtualPath);
                }
            }
            if (AndroidStudioSpecificInitializer.isAndroidStudio()) {
                List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                if (defaultJdk != null) {
                    for (Sdk jdk : jdks) {
                        if (jdk.getName() != defaultJdk.getName()) {
                            sdksToDelete.add(defaultJdk);
                            continue;
                        }
                        DefaultSdks.setJdkPath(jdk, canonicalPath);
                    }
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        }
    }

    @NotNull
    public static List<Sdk> setDefaultAndroidHome(@NotNull File path, @Nullable Project currentProject) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/DefaultSdks", "setDefaultAndroidHome"));
        }
        List<Sdk> list = DefaultSdks.setDefaultAndroidHome(path, null, currentProject);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "setDefaultAndroidHome"));
        }
        return list;
    }

    private static void setJdkPath(@NotNull Sdk sdk, @NotNull File path) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/DefaultSdks", "setJdkPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/DefaultSdks", "setJdkPath"));
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setHomePath(path.getPath());
        sdkModificator.removeAllRoots();
        ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
        JavaSdk.getInstance().setupSdkPaths(sdk);
    }

    private static void updateAllSdks(@NotNull Sdk jdk) {
        if (jdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/android/tools/idea/sdk/DefaultSdks", "updateAllSdks"));
        }
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public static List<Sdk> setDefaultAndroidHome(@NotNull File path, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/DefaultSdks", "setDefaultAndroidHome"));
        }
        if (DefaultSdks.isValidAndroidSdkPath(path)) {
            assert (ApplicationManager.getApplication().isWriteAccessAllowed());
            AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path);
            AndroidSdkUtils.setSdkData(oldSdkData);
            ArrayList sdksToDelete = Lists.newArrayList();
            File resolved = DefaultSdks.resolvePath(path);
            String resolvedPath = resolved.getPath();
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolvedPath);
            if (sdkData != null) {
                for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = DefaultSdks.createAndroidSdksForAllTargets(resolved, javaSdk);
            DefaultSdks.updateLocalPropertiesAndSync(resolved, currentProject);
            List<Sdk> list = sdks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "setDefaultAndroidHome"));
            }
            return list;
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "setDefaultAndroidHome"));
        }
        return list;
    }

    public static boolean isValidAndroidSdkPath(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/DefaultSdks", "isValidAndroidSdkPath"));
        }
        return (Boolean)AndroidSdkType.validateAndroidSdk(path.getPath()).getFirst();
    }

    @NotNull
    public static List<Sdk> createAndroidSdksForAllTargets(@NotNull File androidHome) {
        if (androidHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidHome", "com/android/tools/idea/sdk/DefaultSdks", "createAndroidSdksForAllTargets"));
        }
        List<Sdk> sdks = DefaultSdks.createAndroidSdksForAllTargets(androidHome, null);
        RunAndroidSdkManagerAction.updateInWelcomePage(null);
        List<Sdk> list = sdks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "createAndroidSdksForAllTargets"));
        }
        return list;
    }

    @NotNull
    private static List<Sdk> createAndroidSdksForAllTargets(@NotNull File androidHome, @Nullable Sdk javaSdk) {
        if (androidHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidHome", "com/android/tools/idea/sdk/DefaultSdks", "createAndroidSdksForAllTargets"));
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(androidHome);
        if (sdkData == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "createAndroidSdksForAllTargets"));
            }
            return list;
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        if (targets.length == 0) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "createAndroidSdksForAllTargets"));
            }
            return list;
        }
        ArrayList sdks = Lists.newArrayList();
        Sdk defaultJdk = javaSdk != null ? javaSdk : DefaultSdks.getDefaultJdk();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() || DefaultSdks.doesDefaultAndroidSdkExist(target)) continue;
            String name = AndroidSdkUtils.chooseNameForNewLibrary(target);
            Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, sdkData.getLocation().getPath(), name, defaultJdk, true);
            sdks.add(sdk);
        }
        ArrayList arrayList = sdks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "createAndroidSdksForAllTargets"));
        }
        return arrayList;
    }

    private static boolean doesDefaultAndroidSdkExist(@NotNull IAndroidTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/sdk/DefaultSdks", "doesDefaultAndroidSdkExist"));
        }
        for (Sdk sdk : DefaultSdks.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = DefaultSdks.getTarget(sdk);
            AndroidVersion version = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/sdk/DefaultSdks", "getTarget"));
        }
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdk.getSdkAdditionalData();
        assert (data != null);
        AndroidPlatform androidPlatform = data.getAndroidPlatform();
        assert (androidPlatform != null);
        IAndroidTarget iAndroidTarget = androidPlatform.getTarget();
        if (iAndroidTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "getTarget"));
        }
        return iAndroidTarget;
    }

    private static void updateLocalPropertiesAndSync(final @NotNull File sdkHomePath, @Nullable Project currentProject) {
        LocalProperties localProperties;
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/android/tools/idea/sdk/DefaultSdks", "updateLocalPropertiesAndSync"));
        }
        ProjectManager projectManager = (ProjectManager)ApplicationManager.getApplication().getComponent(ProjectManager.class);
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            return;
        }
        final ArrayList projectsToUpdateNames = Lists.newArrayList();
        ArrayList localPropertiesToUpdate = Lists.newArrayList();
        for (Project project : openProjects) {
            if (!Projects.isGradleProject(project)) continue;
            try {
                localProperties = new LocalProperties(project);
                if (FileUtil.filesEqual((File)sdkHomePath, (File)localProperties.getAndroidSdkPath())) continue;
                localPropertiesToUpdate.add(Pair.create((Object)project, (Object)localProperties));
                if (project.equals(currentProject)) continue;
                projectsToUpdateNames.add("'" + project.getName() + "'");
            }
            catch (IOException e) {
                DefaultSdks.logAndShowErrorWhenUpdatingLocalProperties(project, e, "read", sdkHomePath);
            }
        }
        if (!localPropertiesToUpdate.isEmpty()) {
            if (!projectsToUpdateNames.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String msg = "The local.properties file(s) in the project(s)\n " + projectsToUpdateNames + "\nwill be modified with the path of Android Studio's default Android Studio:\n'" + sdkHomePath + "'";
                        Messages.showErrorDialog((String)String.format(msg, projectsToUpdateNames, sdkHomePath), (String)"Sync Android SDKs");
                    }
                });
            }
            GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
            for (Pair toUpdate : localPropertiesToUpdate) {
                Project project;
                block10: {
                    project = (Project)toUpdate.getFirst();
                    try {
                        localProperties = (LocalProperties)toUpdate.getSecond();
                        if (FileUtil.filesEqual((File)sdkHomePath, (File)localProperties.getAndroidSdkPath())) break block10;
                        localProperties.setAndroidSdkPath(sdkHomePath);
                        localProperties.save();
                    }
                    catch (IOException e) {
                        DefaultSdks.logAndShowErrorWhenUpdatingLocalProperties(project, e, "update", sdkHomePath);
                        continue;
                    }
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) continue;
                projectImporter.requestProjectSync(project, null);
            }
        }
    }

    private static void logAndShowErrorWhenUpdatingLocalProperties(@NotNull Project project, @NotNull Exception error, @NotNull String action, @NotNull File sdkHomePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/sdk/DefaultSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/sdk/DefaultSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/sdk/DefaultSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        if (sdkHomePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomePath", "com/android/tools/idea/sdk/DefaultSdks", "logAndShowErrorWhenUpdatingLocalProperties"));
        }
        LOG.info((Throwable)error);
        String msg = String.format("Unable to %1$s local.properties file in project '%2$s'.\n\nCause: %3$s\n\nPlease manually update the file's '%4$s' property value to \n'%5$s'\nand sync the project with Gradle files.", action, project.getName(), DefaultSdks.getMessage(error), "sdk.dir", sdkHomePath.getPath());
        Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_DIALOG_TITLE);
    }

    @NotNull
    private static String getMessage(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/sdk/DefaultSdks", "getMessage"));
        }
        String cause = e.getMessage();
        if (Strings.isNullOrEmpty((String)cause)) {
            cause = "[Unknown]";
        }
        String string = cause;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "getMessage"));
        }
        return string;
    }

    @NotNull
    private static File resolvePath(@NotNull File path) {
        File file;
        block4: {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/sdk/DefaultSdks", "resolvePath"));
            }
            try {
                String resolvedPath = FileUtil.resolveShortWindowsName((String)path.getPath());
                file = new File(resolvedPath);
                if (file != null) break block4;
            }
            catch (IOException iOException) {
                File file2 = path;
                if (file2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "resolvePath"));
                }
                return file2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "resolvePath"));
        }
        return file;
    }

    @Nullable
    public static Sdk getDefaultJdk() {
        String jdkPath;
        List jdks;
        List<Sdk> androidSdks = DefaultSdks.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)androidSdk.getSdkAdditionalData();
            assert (data != null);
            Sdk jdk = data.getJavaSdk();
            if (jdk != null) {
                return jdk;
            }
        }
        if (!(jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())).isEmpty()) {
            return (Sdk)jdks.get(0);
        }
        Collection jdkPaths = JavaSdk.getInstance().suggestHomePaths();
        VirtualFile javaHome = null;
        Iterator i$ = jdkPaths.iterator();
        while (i$.hasNext() && (javaHome = (jdkPath = (String)i$.next()) != null ? LocalFileSystem.getInstance().findFileByPath(jdkPath) : null) == null) {
        }
        if (javaHome == null) {
            javaHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getJavaHome());
        }
        return javaHome != null ? DefaultSdks.createJdk(javaHome) : null;
    }

    @NotNull
    public static List<Sdk> getEligibleAndroidSdks() {
        ArrayList sdks = Lists.newArrayList();
        for (Sdk sdk : AndroidSdkUtils.getAllAndroidSdks()) {
            SdkAdditionalData sdkData = sdk.getSdkAdditionalData();
            if (!(sdkData instanceof AndroidSdkAdditionalData)) continue;
            AndroidSdkAdditionalData androidSdkData = (AndroidSdkAdditionalData)sdkData;
            if (!sdk.getName().startsWith("Android ") || androidSdkData.getAndroidPlatform() == null) continue;
            sdks.add(sdk);
        }
        ArrayList arrayList = sdks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/DefaultSdks", "getEligibleAndroidSdks"));
        }
        return arrayList;
    }

    @Nullable
    private static Sdk createJdk(@NotNull VirtualFile homeDirectory) {
        if (homeDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeDirectory", "com/android/tools/idea/sdk/DefaultSdks", "createJdk"));
        }
        Sdk newSdk = SdkConfigurationUtil.setupSdk((Sdk[])ProjectJdkTable.getInstance().getAllJdks(), (VirtualFile)homeDirectory, (SdkType)JavaSdk.getInstance(), (boolean)true, null, (String)"JDK");
        if (newSdk != null) {
            SdkConfigurationUtil.addSdk((Sdk)newSdk);
        }
        return newSdk;
    }
}

