/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.welcome.InstallComponentsPath;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class AndroidSdk
extends InstallableComponent {
    public static final long SIZE = 2300L * Storage.Unit.MiB.getNumberOfBytes();
    private static final ScopedStateStore.Key<Boolean> KEY_INSTALL_SDK = ScopedStateStore.createKey("download.sdk", ScopedStateStore.Scope.PATH, Boolean.class);

    public AndroidSdk() {
        super("Android SDK", SIZE, KEY_INSTALL_SDK);
    }

    static PkgDesc.Builder[] getPackages() {
        AndroidVersion lVersion = new AndroidVersion(21, null);
        MajorRevision unspecifiedRevision = new MajorRevision(FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder androidSdkTools = PkgDesc.Builder.newTool((FullRevision)FullRevision.NOT_SPECIFIED, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder androidSdkPlatformTools = PkgDesc.Builder.newPlatformTool((FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder androidSdkBuildTools = PkgDesc.Builder.newBuildTool((FullRevision)new FullRevision(21, 0, 2));
        PkgDesc.Builder supportRepository = InstallComponentsPath.createExtra(true, "android", "m2repository");
        PkgDesc.Builder googleRepository = InstallComponentsPath.createExtra(true, "google", "m2repository");
        PkgDesc.Builder atomImage = PkgDesc.Builder.newSysImg((AndroidVersion)lVersion, (IdDisplay)new IdDisplay("default", ""), (String)"x86", (MajorRevision)unspecifiedRevision);
        PkgDesc.Builder platform = PkgDesc.Builder.newPlatform((AndroidVersion)lVersion, (MajorRevision)unspecifiedRevision, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder sample = PkgDesc.Builder.newSample((AndroidVersion)lVersion, (MajorRevision)unspecifiedRevision, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder platformSources = PkgDesc.Builder.newSource((AndroidVersion)lVersion, (MajorRevision)unspecifiedRevision);
        PkgDesc.Builder usb = InstallComponentsPath.createExtra(SystemInfo.isLinux || SystemInfo.isWindows, "google", "usb_driver");
        return new PkgDesc.Builder[]{androidSdkTools, androidSdkPlatformTools, androidSdkBuildTools, supportRepository, googleRepository, atomImage, platform, sample, platformSources, usb};
    }

    @Override
    @NotNull
    public PkgDesc.Builder[] getRequiredSdkPackages() {
        PkgDesc.Builder[] builderArray = AndroidSdk.getPackages();
        if (builderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/AndroidSdk", "getRequiredSdkPackages"));
        }
        return builderArray;
    }

    @Override
    public void init(@NotNull ScopedStateStore state, @NotNull ProgressStep progressStep) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/welcome/AndroidSdk", "init"));
        }
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/AndroidSdk", "init"));
        }
        state.put(KEY_INSTALL_SDK, true);
    }

    @Override
    public DynamicWizardStep[] createSteps() {
        return new DynamicWizardStep[0];
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/AndroidSdk", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/AndroidSdk", "configure"));
        }
    }

    @Override
    public boolean isOptional() {
        return false;
    }
}

