/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.WizardException;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class PreinstallOperation<T> {
    protected final InstallContext myContext;
    private final double myProgressRatio;

    protected PreinstallOperation(InstallContext context, double progressRatio) {
        this.myContext = context;
        this.myProgressRatio = progressRatio;
    }

    protected abstract T perform() throws WizardException;

    @Nullable
    public final T execute() throws WizardException {
        if (this.myContext.isCanceled()) {
            return null;
        }
        return (T)this.myContext.run(new ThrowableComputable<T, WizardException>(){

            public T compute() throws WizardException {
                return PreinstallOperation.this.perform();
            }
        }, this.myProgressRatio);
    }

    protected final void promptToRetry(final String prompt, String failureDescription, Exception e) throws WizardException {
        final AtomicBoolean response = new AtomicBoolean(false);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int i = Messages.showYesNoDialog(null, (String)prompt, (String)"Android Studio Setup", (String)"Retry", (String)"Cancel", (Icon)Messages.getErrorIcon());
                response.set(i == 0);
            }
        }, application.getAnyModalityState());
        if (!response.get()) {
            throw new WizardException(failureDescription, e);
        }
        this.myContext.print(failureDescription + "\n", ConsoleViewContentType.ERROR_OUTPUT);
    }
}

