/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.FirstRunWizard;
import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardHost;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Atomics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WelcomeScreenHost
extends JPanel
implements WelcomeScreen,
DynamicWizardHost {
    private static final Insets BUTTON_MARGINS = new Insets(2, 16, 2, 16);
    private Action myPreviousAction = new PreviousAction();
    private Action myNextAction = new NextAction();
    private FinishAction myFinishAction = new FinishAction();
    private FirstRunWizard myWizard;
    private JFrame myFrame;
    private String myTitle;
    private Dimension myPreferredWindowSize = new Dimension(800, 600);
    private Map<Action, JButton> myActionToButtonMap = Maps.newHashMap();
    private AtomicReference<ProgressIndicator> myCurrentProgressIndicator = Atomics.newReference();

    public WelcomeScreenHost() {
        super(new BorderLayout());
        this.add((Component)this.createSouthPanel(), "South");
    }

    private static void setMargin(JButton button) {
        if (!SystemInfo.isMac && BUTTON_MARGINS != null) {
            button.setMargin(BUTTON_MARGINS);
        }
    }

    public JComponent getWelcomePanel() {
        if (this.myWizard == null) {
            this.setupWizard();
        }
        assert (this.myWizard != null);
        return this;
    }

    private void setupWizard() {
        FirstRunWizard wizard = new FirstRunWizard(this);
        ((DynamicWizard)wizard).init();
        this.add(wizard.getContentPane(), "Center");
    }

    public void setupFrame(JFrame frame) {
        this.myFrame = frame;
        if (this.myTitle != null) {
            frame.setTitle(this.myTitle);
        }
        frame.setSize(this.myPreferredWindowSize);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (size.width - this.myPreferredWindowSize.width) / 2;
        int y = (size.height - this.myPreferredWindowSize.height) / 2;
        frame.setLocation(x, y);
        JButton defaultButton = this.myActionToButtonMap.get(this.myFinishAction);
        if (!defaultButton.isEnabled()) {
            defaultButton = this.myActionToButtonMap.get(this.myNextAction);
        }
        this.setDefaultButton(defaultButton);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        WelcomeScreenHost welcomeScreenHost = this;
        if (welcomeScreenHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/WelcomeScreenHost", "getDisposable"));
        }
        return welcomeScreenHost;
    }

    @Override
    public void init(@NotNull DynamicWizard wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/welcome/WelcomeScreenHost", "init"));
        }
        this.myWizard = (FirstRunWizard)wizard;
    }

    @Override
    public boolean showAndGet() {
        return false;
    }

    @Override
    public void close(boolean canceled) {
        if (canceled) {
            this.myFrame.setVisible(false);
            this.myFrame.dispose();
        } else {
            this.setDefaultButton(null);
            NewWelcomeScreen welcomeScreen = new NewWelcomeScreen();
            Disposer.register((Disposable)this.getDisposable(), (Disposable)welcomeScreen);
            this.myFrame.setContentPane(welcomeScreen.getWelcomePanel());
            welcomeScreen.setupFrame(this.myFrame);
        }
    }

    @Override
    public void shakeWindow() {
    }

    @Override
    public void updateButtons(boolean canGoPrev, boolean canGoNext, boolean canFinish) {
        this.setButtonEnabled(this.myPreviousAction, canGoPrev);
        this.setButtonEnabled(this.myNextAction, canGoNext);
        this.setButtonEnabled(this.myFinishAction, canFinish);
        if (this.myFrame != null) {
            this.setDefaultButton(this.myActionToButtonMap.get(canFinish ? this.myFinishAction : this.myNextAction));
        }
    }

    private void setButtonEnabled(Action action, boolean enabled) {
        JButton button = this.myActionToButtonMap.get(action);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    @Override
    public void setTitle(String title) {
        this.myTitle = title;
        if (this.myFrame != null) {
            this.myFrame.setTitle(title);
        }
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
    }

    @Override
    public void runSensitiveOperation(@NotNull ProgressIndicator progressIndicator, boolean cancellable, @NotNull Runnable operation) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/welcome/WelcomeScreenHost", "runSensitiveOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/android/tools/idea/welcome/WelcomeScreenHost", "runSensitiveOperation"));
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!this.myCurrentProgressIndicator.compareAndSet(null, progressIndicator)) {
            throw new IllegalStateException("Submitting an operation while another is in progress.");
        }
        JRootPane rootPane = this.myFrame.getRootPane();
        JButton defaultButton = rootPane.getDefaultButton();
        rootPane.setDefaultButton(null);
        this.updateButtons(false, false, true);
        this.myFinishAction.putValue("Name", IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
        WindowListener removed = this.removeCloseListener();
        LongRunningOperationWrapper task = new LongRunningOperationWrapper(operation, cancellable, defaultButton, removed);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, progressIndicator);
    }

    @Nullable
    private WindowListener removeCloseListener() {
        WindowListener[] listeners;
        for (WindowListener listener : listeners = (WindowListener[])this.myFrame.getListeners(WindowListener.class)) {
            if (!listener.getClass().getName().startsWith(WelcomeFrame.class.getName())) continue;
            this.myFrame.removeWindowListener(listener);
            return listener;
        }
        return null;
    }

    @NotNull
    private JComponent createSouthPanel() {
        Insets insets;
        Action[] actions = this.createActions();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel lrButtonsPanel = new JPanel(new GridBagLayout());
        Insets insets2 = insets = SystemInfo.isMacOSLeopard ? new Insets(0, 0, 0, 0) : new Insets(8, 0, 0, 0);
        if (actions.length > 0) {
            int gridX = 0;
            lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridX++, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            if (actions.length > 0) {
                JPanel buttonsPanel = this.createButtons(actions, buttons);
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridX, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            }
        }
        panel.add((Component)lrButtonsPanel, "Center");
        panel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)WizardConstants.STUDIO_WIZARD_INSETS));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/WelcomeScreenHost", "createSouthPanel"));
        }
        return jPanel;
    }

    private Action[] createActions() {
        return new Action[]{this.myPreviousAction, this.myNextAction, this.myFinishAction};
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions, @NotNull List<JButton> buttons) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/welcome/WelcomeScreenHost", "createButtons"));
        }
        if (buttons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buttons", "com/android/tools/idea/welcome/WelcomeScreenHost", "createButtons"));
        }
        if (!UISettings.getShadowInstance().ALLOW_MERGE_BUTTONS) {
            ArrayList<Action> actionList = new ArrayList<Action>();
            for (Action action : actions) {
                actionList.add(action);
                if (!(action instanceof OptionAction)) continue;
                Action[] options = ((OptionAction)action).getOptions();
                actionList.addAll(Arrays.asList(options));
            }
            if (actionList.size() != actions.length) {
                actions = actionList.toArray(actionList.toArray(new Action[actionList.size()]));
            }
        }
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions.length, SystemInfo.isMacOSLeopard ? 0 : 5, 0));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                button.setMnemonic(mnemonic);
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        JPanel jPanel = buttonsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/WelcomeScreenHost", "createButtons"));
        }
        return jPanel;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = new JButton(action);
        String text = button.getText();
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        if (text != null) {
            int mnemonic = 0;
            StringBuilder plainText = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                int ch = text.charAt(i);
                if (ch == 95 || ch == 38) {
                    if (i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != 95 && ch != 38) {
                        int vk = ch;
                        if (vk >= 97 && vk <= 122) {
                            vk -= 32;
                        }
                        mnemonic = vk;
                    }
                }
                plainText.append((char)ch);
            }
            button.setText(plainText.toString());
            button.setMnemonic(mnemonic);
            WelcomeScreenHost.setMargin(button);
        }
        this.myActionToButtonMap.put(action, button);
        return button;
    }

    @Override
    public void setPreferredWindowSize(Dimension preferredWindowSize) {
        this.myPreferredWindowSize = preferredWindowSize;
        if (this.myFrame != null) {
            this.myFrame.setSize(preferredWindowSize);
        }
    }

    private void setDefaultButton(@Nullable JButton button) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.setDefaultButton(button);
        }
    }

    private class LongRunningOperationWrapper
    extends Task.Backgroundable {
        private final Runnable myOperation;
        private final JButton myDefaultButton;
        private final WindowListener myRemoved;

        public LongRunningOperationWrapper(Runnable operation, boolean cancellable, @Nullable JButton defaultButton, WindowListener suspendedListener) {
            super(null, WelcomeScreenHost.this.myWizard.getWizardActionDescription(), cancellable);
            this.myOperation = operation;
            this.myDefaultButton = defaultButton;
            this.myRemoved = suspendedListener;
        }

        public void onSuccess() {
            WelcomeScreenHost.this.myCurrentProgressIndicator.set(null);
            WelcomeScreenHost.this.myFinishAction.putValue("Name", IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
            WelcomeScreenHost.this.updateButtons(false, false, true);
            WelcomeScreenHost.this.myFrame.getRootPane().setDefaultButton(this.myDefaultButton);
            if (this.myRemoved != null) {
                WelcomeScreenHost.this.myFrame.addWindowListener(this.myRemoved);
            }
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/WelcomeScreenHost$LongRunningOperationWrapper", "run"));
            }
            this.myOperation.run();
        }

        public void onCancel() {
            this.onSuccess();
        }
    }

    protected class FinishAction
    extends AbstractAction {
        protected FinishAction() {
            this.putValue("Name", IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressIndicator indicator = (ProgressIndicator)WelcomeScreenHost.this.myCurrentProgressIndicator.get();
            if (indicator == null) {
                WelcomeScreenHost.this.myWizard.doFinishAction();
            } else {
                indicator.cancel();
                WelcomeScreenHost.this.setButtonEnabled(this, false);
            }
        }
    }

    protected class PreviousAction
    extends AbstractAction {
        protected PreviousAction() {
            this.putValue("Name", IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WelcomeScreenHost.this.myWizard.doPreviousAction();
        }
    }

    protected class NextAction
    extends AbstractAction {
        protected NextAction() {
            this.putValue("Name", IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WelcomeScreenHost.this.myWizard.doNextAction();
        }
    }
}

