/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ImageComponent;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStep
extends ScopedDataBinder
implements Step {
    private static final Logger LOG = Logger.getInstance(DynamicWizardStep.class);
    protected DynamicWizardPath myPath;
    private boolean myUpdateInProgress;
    private boolean myIsValid;
    private boolean myInitialized;

    public DynamicWizardStep() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    public static JPanel createWizardStepHeader(JBColor headerColor, Icon icon, String title) {
        JPanel panel = new JPanel();
        panel.setBackground((Color)headerColor);
        panel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        panel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(18, 0, 12, 0), 2, 2));
        GridConstraints c = new GridConstraints(0, 0, 2, 1, 9, 0, 0, 0, null, new Dimension(60, 60), null);
        ImageComponent image = new ImageComponent(icon);
        panel.add((Component)((Object)image), c);
        c = new GridConstraints(0, 1, 1, 1, 10, 1, 6, 0, null, null, null);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setForeground(Color.WHITE);
        titleLabel.setFont(titleLabel.getFont().deriveFont(24.0f));
        panel.add((Component)titleLabel, c);
        c.setRow(1);
        c.setAnchor(9);
        JLabel productLabel = new JLabel("Android Studio");
        productLabel.setForeground(Color.WHITE);
        panel.add((Component)productLabel, c);
        return panel;
    }

    public final void attachToPath(@NotNull DynamicWizardPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/wizard/DynamicWizardStep", "attachToPath"));
        }
        this.myPath = path;
        Map<String, Object> myCurrentValues = this.myState.flatten();
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, this.myPath.getState(), this);
        for (String keyName : myCurrentValues.keySet()) {
            this.myState.put(this.myState.createKey(keyName, Object.class), myCurrentValues.get(keyName));
        }
    }

    public abstract void init();

    @Nullable
    protected final Project getProject() {
        return this.myPath != null ? this.myPath.getProject() : null;
    }

    @Nullable
    protected final Module getModule() {
        return this.myPath != null ? this.myPath.getModule() : null;
    }

    @Nullable
    protected final DynamicWizard getWizard() {
        if (this.myPath != null) {
            return this.myPath.getWizard();
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Deprecated
    public final void _init() {
        this.onEnterStep();
    }

    @Deprecated
    public final void _commit(boolean finishChosen) throws CommitStepException {
        this.commitStep();
    }

    public void onEnterStep() {
        if (!this.myInitialized) {
            this.init();
            this.myInitialized = true;
        }
        this.invokeUpdate(null);
    }

    public boolean commitStep() {
        return true;
    }

    public boolean isStepVisible() {
        return true;
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        super.invokeUpdate(changedKey);
        this.update();
        if (this.myPath != null) {
            this.myPath.updateButtons();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.updateModelFromUI();
            this.deriveValues(this.myState.getRecentUpdates());
            this.myIsValid = this.validate();
            this.myState.clearRecentUpdates();
            this.myUpdateInProgress = false;
        }
    }

    public void updateModelFromUI() {
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public boolean validate() {
        return true;
    }

    public boolean canGoNext() {
        return this.myIsValid;
    }

    public boolean canGoPrevious() {
        return true;
    }

    public final void setErrorHtml(@Nullable String errorMessage) {
        JLabel label;
        if (errorMessage != null && !errorMessage.startsWith("<html>")) {
            errorMessage = "<html>" + errorMessage + "</html>";
        }
        if ((label = this.getMessageLabel()) != null) {
            label.setText(errorMessage);
        } else {
            LOG.debug("Message was displayed on a step without error label", (Throwable)new Exception());
        }
    }

    public String toString() {
        return this.getStepName();
    }

    @NotNull
    public abstract JComponent getComponent();

    @Nullable
    public abstract JLabel getMessageLabel();

    @NotNull
    public abstract String getStepName();
}

