/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout;

import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.designer.SegmentType;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TextDirection {
    LEFT_TO_RIGHT,
    RIGHT_TO_LEFT;


    public static TextDirection fromAndroidDesignerEditorPanel(@Nullable AndroidDesignerEditorPanel panel) {
        Configuration configuration;
        Configuration configuration2 = configuration = panel != null ? panel.getConfiguration() : null;
        if (configuration == null) {
            return LEFT_TO_RIGHT;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        return qualifier == null || qualifier.getValue() != LayoutDirection.RTL ? LEFT_TO_RIGHT : RIGHT_TO_LEFT;
    }

    @NotNull
    public SegmentType getLeftSegment() {
        SegmentType segmentType = this == LEFT_TO_RIGHT ? SegmentType.START : SegmentType.END;
        if (segmentType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getLeftSegment"));
        }
        return segmentType;
    }

    @NotNull
    public SegmentType getRightSegment() {
        SegmentType segmentType = this == LEFT_TO_RIGHT ? SegmentType.END : SegmentType.START;
        if (segmentType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getRightSegment"));
        }
        return segmentType;
    }

    public boolean isLeftSegment(@NotNull SegmentType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/android/designer/model/layout/TextDirection", "isLeftSegment"));
        }
        return type == SegmentType.LEFT || type == this.getLeftSegment();
    }

    public boolean isRightSegment(@NotNull SegmentType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/android/designer/model/layout/TextDirection", "isRightSegment"));
        }
        return type == SegmentType.RIGHT || type == this.getRightSegment();
    }

    @NotNull
    public String getAttrLeft() {
        String string = this == LEFT_TO_RIGHT ? "layout_alignStart" : "layout_alignEnd";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrLeft"));
        }
        return string;
    }

    @NotNull
    public String getAttrLeftOf() {
        String string = this == LEFT_TO_RIGHT ? "layout_toStartOf" : "layout_toEndOf";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrLeftOf"));
        }
        return string;
    }

    @NotNull
    public String getAttrRight() {
        String string = this == LEFT_TO_RIGHT ? "layout_alignEnd" : "layout_alignStart";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrRight"));
        }
        return string;
    }

    @NotNull
    public String getAttrRightOf() {
        String string = this == LEFT_TO_RIGHT ? "layout_toEndOf" : "layout_toStartOf";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrRightOf"));
        }
        return string;
    }

    @NotNull
    public String getAttrAlignParentLeft() {
        String string = this == LEFT_TO_RIGHT ? "layout_alignParentStart" : "layout_alignParentEnd";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrAlignParentLeft"));
        }
        return string;
    }

    @NotNull
    public String getAttrAlignParentRight() {
        String string = this == LEFT_TO_RIGHT ? "layout_alignParentEnd" : "layout_alignParentStart";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrAlignParentRight"));
        }
        return string;
    }

    @NotNull
    public String getAttrMarginLeft() {
        String string = this == LEFT_TO_RIGHT ? "layout_marginStart" : "layout_marginEnd";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrMarginLeft"));
        }
        return string;
    }

    @NotNull
    public String getAttrMarginRight() {
        String string = this == LEFT_TO_RIGHT ? "layout_marginEnd" : "layout_marginStart";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/TextDirection", "getAttrMarginRight"));
        }
        return string;
    }
}

