/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenRedundantGroupIdInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = MavenDomBundle.message("inspection.redundant.groupId.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("MavenRedundantGroupId" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection", "getShortName"));
        }
        return "MavenRedundantGroupId";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        MavenDomParent parent;
        String parentGroupId;
        MavenDomProjectModel projectModel;
        String groupId;
        DomFileElement model;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection", "checkFile"));
        }
        if (file instanceof XmlFile && (file.isPhysical() || ApplicationManager.getApplication().isUnitTestMode()) && (model = DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, MavenDomProjectModel.class)) != null && (groupId = (projectModel = (MavenDomProjectModel)model.getRootElement()).getGroupId().getStringValue()) != null && groupId.length() > 0 && groupId.equals(parentGroupId = (parent = projectModel.getMavenParent()).getGroupId().getStringValue())) {
            XmlTag xmlTag = projectModel.getGroupId().getXmlTag();
            LocalQuickFixBase fix = new LocalQuickFixBase("Remove unnecessary <groupId>"){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection$1", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/maven/dom/inspections/MavenRedundantGroupIdInspection$1", "applyFix"));
                    }
                    PsiElement xmlTag = descriptor.getPsiElement();
                    if (xmlTag.isValid() && FileModificationService.getInstance().preparePsiElementForWrite(xmlTag)) {
                        xmlTag.delete();
                    }
                }
            };
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)xmlTag, "Definition of groupId is redundant, because it's inherited from the parent", (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
        }
        return null;
    }
}

