/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;

public class StatusWalkerPartner {
    private final SvnVcs myVcs;
    private final ChangeListManager myClManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ProgressIndicator myIndicator;
    private ISVNStatusFileProvider myFileProvider;

    public StatusWalkerPartner(SvnVcs vcs, ProgressIndicator pi) {
        this.myVcs = vcs;
        this.myClManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject());
        this.myIndicator = pi;
    }

    public void setFileProvider(ISVNStatusFileProvider fileProvider) {
        this.myFileProvider = fileProvider;
    }

    @NotNull
    public ProgressTracker getEventHandler() {
        ProgressTracker progressTracker = new ProgressTracker(){

            public void consume(ProgressEvent event) throws SVNException {
            }

            @Override
            public void checkCancelled() throws SVNCancelException {
                if (StatusWalkerPartner.this.myIndicator != null) {
                    StatusWalkerPartner.this.myIndicator.checkCanceled();
                }
            }
        };
        if (progressTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/StatusWalkerPartner", "getEventHandler"));
        }
        return progressTracker;
    }

    @Nullable
    public ISVNStatusFileProvider getFileProvider() {
        return this.myFileProvider;
    }

    public void checkCanceled() {
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
        }
    }

    public boolean isIgnoredByVcs(final VirtualFile vFile) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (StatusWalkerPartner.this.myVcs.getProject().isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return StatusWalkerPartner.this.myVcsManager.isIgnored(vFile);
            }
        });
    }

    public boolean isIgnoredIdeaLevel(VirtualFile vFile) {
        return this.myClManager.isIgnoredFile(vFile);
    }
}

