/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigIndentOptionsProvider
extends FileIndentOptionsProvider {
    private static final String indentSizeKey = "indent_size";
    private static final String continuationSizeKey = "continuation_indent_size";
    private static final String tabWidthKey = "tab_width";
    private static final String indentStyleKey = "indent_style";

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/editorconfig/configmanagement/EditorConfigIndentOptionsProvider", "getIndentOptions"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/editorconfig/configmanagement/EditorConfigIndentOptionsProvider", "getIndentOptions"));
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        Project project = psiFile.getProject();
        if (!Utils.isEnabled(settings)) {
            return null;
        }
        String filePath = Utils.getFilePath(project, file);
        SettingsProviderComponent settingsProvider = SettingsProviderComponent.getInstance();
        List<EditorConfig.OutPair> outPairs = settingsProvider.getOutPairs(project, filePath);
        return EditorConfigIndentOptionsProvider.applyCodeStyleSettings(project, outPairs, file, settings);
    }

    private static CommonCodeStyleSettings.IndentOptions applyCodeStyleSettings(Project project, List<EditorConfig.OutPair> outPairs, VirtualFile file, CodeStyleSettings settings) {
        String indentSize = Utils.configValueForKey(outPairs, indentSizeKey);
        String continuationIndentSize = Utils.configValueForKey(outPairs, continuationSizeKey);
        String tabWidth = Utils.configValueForKey(outPairs, tabWidthKey);
        String indentStyle = Utils.configValueForKey(outPairs, indentStyleKey);
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)settings.getIndentOptions(file.getFileType()).clone();
        if (EditorConfigIndentOptionsProvider.applyIndentOptions(project, indentOptions, indentSize, continuationIndentSize, tabWidth, indentStyle, file.getCanonicalPath())) {
            return indentOptions;
        }
        return null;
    }

    private static boolean applyIndentOptions(Project project, CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize, String continuationIndentSize, String tabWidth, String indentStyle, String filePath) {
        boolean changed = false;
        String calculatedIndentSize = EditorConfigIndentOptionsProvider.calculateIndentSize(tabWidth, indentSize);
        String calculatedContinuationSize = EditorConfigIndentOptionsProvider.calculateContinuationIndentSize(calculatedIndentSize, continuationIndentSize);
        String calculatedTabWidth = EditorConfigIndentOptionsProvider.calculateTabWidth(tabWidth, indentSize);
        if (!calculatedIndentSize.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyIndentSize(indentOptions, calculatedIndentSize)) {
                Utils.appliedConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
            }
        }
        if (!calculatedContinuationSize.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyContinuationIndentSize(indentOptions, calculatedContinuationSize)) {
                Utils.appliedConfigMessage(project, calculatedContinuationSize, continuationSizeKey, filePath);
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedIndentSize, indentSizeKey, filePath);
            }
        }
        if (!calculatedTabWidth.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyTabWidth(indentOptions, calculatedTabWidth)) {
                Utils.appliedConfigMessage(project, calculatedTabWidth, tabWidthKey, filePath);
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, calculatedTabWidth, tabWidthKey, filePath);
            }
        }
        if (!indentStyle.isEmpty()) {
            if (EditorConfigIndentOptionsProvider.applyIndentStyle(indentOptions, indentStyle)) {
                Utils.appliedConfigMessage(project, indentStyle, indentStyleKey, filePath);
                changed = true;
            } else {
                Utils.invalidConfigMessage(project, indentStyle, indentStyleKey, filePath);
            }
        }
        return changed;
    }

    private static String calculateIndentSize(String tabWidth, String indentSize) {
        return indentSize.equals("tab") ? tabWidth : indentSize;
    }

    private static String calculateContinuationIndentSize(String indentSize, String continuationIndentSize) {
        return continuationIndentSize.isEmpty() ? indentSize : continuationIndentSize;
    }

    private static String calculateTabWidth(String tabWidth, String indentSize) {
        if (tabWidth.isEmpty() && indentSize.equals("tab")) {
            return "";
        }
        if (tabWidth.isEmpty()) {
            return indentSize;
        }
        return tabWidth;
    }

    private static boolean applyIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize) {
        try {
            indentOptions.INDENT_SIZE = Integer.parseInt(indentSize);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyContinuationIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String continuationIndentSize) {
        try {
            indentOptions.CONTINUATION_INDENT_SIZE = Integer.parseInt(continuationIndentSize);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyTabWidth(CommonCodeStyleSettings.IndentOptions indentOptions, String tabWidth) {
        try {
            indentOptions.TAB_SIZE = Integer.parseInt(tabWidth);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean applyIndentStyle(CommonCodeStyleSettings.IndentOptions indentOptions, String indentStyle) {
        if (indentStyle.equals("tab") || indentStyle.equals("space")) {
            indentOptions.USE_TAB_CHARACTER = indentStyle.equals("tab");
            return true;
        }
        return false;
    }
}

