/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.ConversionException;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;

public class EclipseClasspathStorageProvider
implements ClasspathStorageProvider {
    public static final String DESCR = EclipseBundle.message("eclipse.classpath.storage.description", new Object[0]);

    @NonNls
    public String getID() {
        return "eclipse";
    }

    @Nls
    public String getDescription() {
        return DESCR;
    }

    public void assertCompatible(ModuleRootModel model) throws ConfigurationException {
        String moduleName = model.getModule().getName();
        for (OrderEntry entry : model.getOrderEntries()) {
            Library library;
            LibraryOrderEntry libraryEntry;
            if (!(entry instanceof LibraryOrderEntry) || !(libraryEntry = (LibraryOrderEntry)entry).isModuleLevel() || (library = libraryEntry.getLibrary()) != null && libraryEntry.getRootUrls(OrderRootType.CLASSES).length == 1 && !library.isJarDirectory(library.getUrls(OrderRootType.CLASSES)[0])) continue;
            throw new ConfigurationException("Library '" + entry.getPresentableName() + "' from module '" + moduleName + "' dependencies is incompatible with eclipse format which supports only one library content root");
        }
        if (model.getContentRoots().length == 0) {
            throw new ConfigurationException("Module '" + moduleName + "' has no content roots thus is not compatible with eclipse format");
        }
        String output = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        String contentRoot = this.getContentRoot(model);
        if (output == null || !StringUtil.startsWith((CharSequence)VfsUtilCore.urlToPath((String)output), (CharSequence)contentRoot) && PathMacroManager.getInstance((ComponentManager)model.getModule()).collapsePath(output).equals(output)) {
            throw new ConfigurationException("Module '" + moduleName + "' output path is incompatible with eclipse format which supports output under content root only.\nPlease make sure that \"Inherit project compile output path\" is not selected");
        }
    }

    public void detach(Module module) {
        EclipseModuleManagerImpl.getInstance(module).setDocumentSet(null);
    }

    public ClasspathStorageProvider.ClasspathConverter createConverter(Module module) {
        return new EclipseClasspathConverter(module);
    }

    public String getContentRoot(ModuleRootModel model) {
        VirtualFile contentRoot = EPathUtil.getContentRoot(model);
        if (contentRoot != null) {
            return contentRoot.getPath();
        }
        return model.getContentRoots()[0].getPath();
    }

    public void modulePathChanged(Module module, String path) {
        EclipseModuleManagerImpl moduleManager = EclipseModuleManagerImpl.getInstance(module);
        if (moduleManager != null) {
            moduleManager.setDocumentSet(null);
        }
    }

    public static void registerFiles(CachedXmlDocumentSet fileCache, Module module, String moduleRoot, String storageRoot) {
        fileCache.register(".classpath", storageRoot);
        fileCache.register(".project", storageRoot);
        fileCache.register("plugin.xml", storageRoot);
        fileCache.register(module.getName() + ".eml", moduleRoot);
    }

    @NotNull
    static CachedXmlDocumentSet getFileCache(@NotNull Module module) {
        CachedXmlDocumentSet fileCache;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "getFileCache"));
        }
        EclipseModuleManagerImpl moduleManager = EclipseModuleManagerImpl.getInstance(module);
        CachedXmlDocumentSet cachedXmlDocumentSet = fileCache = moduleManager != null ? moduleManager.getDocumentSet() : null;
        if (fileCache == null) {
            fileCache = new CachedXmlDocumentSet(module.getProject());
            if (moduleManager != null) {
                moduleManager.setDocumentSet(fileCache);
            }
            EclipseClasspathStorageProvider.registerFiles(fileCache, module, ClasspathStorage.getModuleDir((Module)module), ClasspathStorage.getStorageRootFromOptions((Module)module));
            fileCache.preload();
        }
        CachedXmlDocumentSet cachedXmlDocumentSet2 = fileCache;
        if (cachedXmlDocumentSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider", "getFileCache"));
        }
        return cachedXmlDocumentSet2;
    }

    public void moduleRenamed(Module module, String newName) {
        if (ClassPathStorageUtil.getStorageType((Module)module).equals("eclipse")) {
            try {
                String oldEmlName = module.getName() + ".eml";
                String root = EclipseClasspathStorageProvider.getFileCache(module).getParent(oldEmlName);
                File source = new File(root, oldEmlName);
                if (source.exists()) {
                    File target = new File(root, newName + ".eml");
                    FileUtil.rename((File)source, (File)target);
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(target);
                }
                CachedXmlDocumentSet fileCache = EclipseClasspathStorageProvider.getFileCache(module);
                DotProjectFileHelper.saveDotProjectFile(module, fileCache.getParent(".project"));
                fileCache.delete(oldEmlName);
                fileCache.register(newName + ".eml", ClasspathStorage.getModuleDir((Module)module));
                fileCache.load(newName + ".eml", true);
            }
            catch (IOException ignore) {
            }
            catch (JDOMException jDOMException) {
                // empty catch block
            }
        }
    }

    public static class EclipseClasspathConverter
    implements ClasspathStorageProvider.ClasspathConverter {
        private final Module module;

        public EclipseClasspathConverter(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider$EclipseClasspathConverter", "<init>"));
            }
            this.module = module;
        }

        public CachedXmlDocumentSet getFileSet() {
            return EclipseClasspathStorageProvider.getFileCache(this.module);
        }

        public Set<String> getClasspath(@NotNull ModifiableRootModel model, @NotNull Element element) throws IOException, InvalidDataException {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider$EclipseClasspathConverter", "getClasspath"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/eclipse/config/EclipseClasspathStorageProvider$EclipseClasspathConverter", "getClasspath"));
            }
            try {
                Object usedVariables;
                CachedXmlDocumentSet documentSet = this.getFileSet();
                String path = documentSet.getParent(".project");
                if (!documentSet.exists(".project")) {
                    if (!documentSet.exists(".classpath")) {
                        return Collections.emptySet();
                    }
                    path = documentSet.getParent(".classpath");
                }
                EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, this.module.getProject(), null);
                classpathReader.init(model);
                if (documentSet.exists(".classpath")) {
                    usedVariables = new THashSet();
                    classpathReader.readClasspath(model, (Collection<String>)new SmartList(), (Collection<String>)new SmartList(), (Set<String>)usedVariables, (Set<String>)new THashSet(), null, documentSet.read(".classpath", false).getRootElement());
                } else {
                    EclipseClasspathReader.setOutputUrl(model, path + "/bin");
                    usedVariables = Collections.emptySet();
                }
                String eml = model.getModule().getName() + ".eml";
                if (documentSet.exists(eml)) {
                    IdeaSpecificSettings.readIDEASpecific(model, documentSet, eml);
                } else {
                    ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
                }
                ((RootModelImpl)model).writeExternal(element);
                return usedVariables;
            }
            catch (ConversionException e) {
                throw new InvalidDataException((Throwable)e);
            }
            catch (WriteExternalException e) {
                throw new InvalidDataException((Throwable)e);
            }
            catch (JDOMException e) {
                throw new InvalidDataException((Throwable)e);
            }
        }

        public void setClasspath(ModuleRootModel model) throws IOException, WriteExternalException {
            try {
                Element element;
                Element classpathElement = new Element("classpath");
                EclipseClasspathWriter classpathWriter = new EclipseClasspathWriter(model);
                CachedXmlDocumentSet fileSet = this.getFileSet();
                try {
                    element = fileSet.read(".classpath").getRootElement();
                }
                catch (Exception e) {
                    element = null;
                }
                if (element != null || model.getSourceRoots().length > 0 || model.getOrderEntries().length > 2) {
                    classpathWriter.writeClasspath(classpathElement, element);
                    fileSet.write(new Document(classpathElement), ".classpath");
                }
                try {
                    fileSet.read(".project");
                }
                catch (Exception e) {
                    DotProjectFileHelper.saveDotProjectFile(this.module, fileSet.getParent(".project"));
                }
                Element ideaSpecific = new Element("component");
                String emlFilename = model.getModule().getName() + ".eml";
                if (IdeaSpecificSettings.writeIDEASpecificClasspath(ideaSpecific, model)) {
                    fileSet.write(new Document(ideaSpecific), emlFilename);
                } else {
                    fileSet.delete(emlFilename);
                }
            }
            catch (ConversionException e) {
                throw new WriteExternalException(e.getMessage());
            }
        }
    }
}

