/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectRevisionInGitLogAction
extends DumbAwareAction {
    public SelectRevisionInGitLogAction() {
        super(GitBundle.getString("vcs.history.action.gitlog"), GitBundle.getString("vcs.history.action.gitlog"), null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Content[] contents;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "actionPerformed"));
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        final VcsLog log = SelectRevisionInGitLogAction.findLog(project);
        assert (log != null);
        final VcsRevisionNumber revision = SelectRevisionInGitLogAction.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
        }
        Runnable selectCommit = new Runnable(){

            @Override
            public void run() {
                log.jumpToReference(revision.asString());
            }
        };
        if (!window.isVisible()) {
            window.activate(selectCommit, true);
        } else {
            selectCommit.run();
        }
    }

    @Nullable
    private static VcsRevisionNumber getRevisionNumber(@NotNull AnActionEvent event) {
        VcsFileRevision fileRevision;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "getRevisionNumber"));
        }
        VcsRevisionNumber revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revision == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "update"));
        }
        super.update(e);
        e.getPresentation().setEnabled(e.getProject() != null && SelectRevisionInGitLogAction.findLog(e.getProject()) != null && (e.getData(VcsDataKeys.VCS_FILE_REVISION) != null || e.getData(VcsDataKeys.VCS_REVISION_NUMBER) != null));
    }

    @Nullable
    private static VcsLog findLog(@NotNull Project project) {
        VcsLogUiImpl ui;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/wholeTree/SelectRevisionInGitLogAction", "findLog"));
        }
        VcsLogManager manager = VcsLogContentProvider.findLogManager((Project)project);
        if (manager != null && (ui = manager.getLogUi()) != null) {
            return ui.getVcsLog();
        }
        return null;
    }
}

