/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nullable;

public class BaseRepositoryEditor<T extends BaseRepository>
extends TaskRepositoryEditor
implements PanelWithAnchor {
    protected JBLabel myUrlLabel;
    protected JTextField myURLText;
    protected JTextField myUserNameText;
    protected JBLabel myUsernameLabel;
    protected JCheckBox myShareUrlCheckBox;
    protected JPasswordField myPasswordText;
    protected JBLabel myPasswordLabel;
    protected JButton myTestButton;
    private JPanel myPanel;
    private JBCheckBox myUseProxy;
    private JButton myProxySettingsButton;
    protected JCheckBox myUseHttpAuthenticationCheckBox;
    protected JPanel myCustomPanel;
    private JBCheckBox myAddCommitMessage;
    private JBLabel myComment;
    private JPanel myEditorPanel;
    protected JBCheckBox myLoginAnonymouslyJBCheckBox;
    protected JBTabbedPane myTabbedPane;
    private JTextPane myAdvertiser;
    private boolean myApplying;
    protected Project myProject;
    protected final T myRepository;
    private final Consumer<T> myChangeListener;
    private final Document myDocument;
    private final Editor myEditor;
    private JComponent myAnchor;

    public BaseRepositoryEditor(final Project project, T repository, Consumer<T> changeListener) {
        this.myProject = project;
        this.myRepository = repository;
        this.myChangeListener = changeListener;
        this.$$$setupUI$$$();
        this.myTestButton.addActionListener(new ActionListener((BaseRepository)repository){
            final /* synthetic */ BaseRepository val$repository;
            {
                this.val$repository = baseRepository;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRepositoryEditor.this.afterTestConnection(TaskManager.getManager(project).testConnection(this.val$repository));
            }
        });
        this.myProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpConfigurable.editConfigurable((JComponent)BaseRepositoryEditor.this.myPanel);
                BaseRepositoryEditor.this.enableButtons();
                BaseRepositoryEditor.this.doApply();
            }
        });
        this.myURLText.setText(((TaskRepository)repository).getUrl());
        this.myUserNameText.setText(((BaseRepository)repository).getUsername());
        this.myPasswordText.setText(((BaseRepository)repository).getPassword());
        this.myShareUrlCheckBox.setSelected(((TaskRepository)repository).isShared());
        this.myUseProxy.setSelected(((BaseRepository)repository).isUseProxy());
        this.myUseHttpAuthenticationCheckBox.setSelected(((BaseRepository)repository).isUseHttpAuthentication());
        this.myUseHttpAuthenticationCheckBox.setVisible(((TaskRepository)repository).isSupported(1));
        this.myLoginAnonymouslyJBCheckBox.setVisible(((TaskRepository)repository).isSupported(2));
        this.myLoginAnonymouslyJBCheckBox.setSelected(((BaseRepository)repository).isLoginAnonymously());
        this.myLoginAnonymouslyJBCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRepositoryEditor.this.loginAnonymouslyChanged(!BaseRepositoryEditor.this.myLoginAnonymouslyJBCheckBox.isSelected());
            }
        });
        this.myAddCommitMessage.setSelected(((TaskRepository)repository).isShouldFormatCommitMessage());
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)((TaskRepository)repository).getCommitMessageFormat());
        this.myEditor = EditorFactory.getInstance().createEditor(this.myDocument);
        this.myEditorPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myComment.setText("Available placeholders: " + ((TaskRepository)repository).getComment());
        String advertiser = ((TaskRepository)repository).getRepositoryType().getAdvertiser();
        if (advertiser != null) {
            Messages.installHyperlinkSupport((JTextPane)this.myAdvertiser);
            this.myAdvertiser.setText(advertiser);
        } else {
            this.myAdvertiser.setVisible(false);
        }
        this.installListener((JCheckBox)this.myAddCommitMessage);
        this.installListener(this.myDocument);
        this.installListener(this.myURLText);
        this.installListener(this.myUserNameText);
        this.installListener(this.myPasswordText);
        this.installListener(this.myShareUrlCheckBox);
        this.installListener((JCheckBox)this.myUseProxy);
        this.installListener(this.myUseHttpAuthenticationCheckBox);
        this.installListener((JCheckBox)this.myLoginAnonymouslyJBCheckBox);
        this.enableButtons();
        JComponent customPanel = this.createCustomPanel();
        if (customPanel != null) {
            this.myCustomPanel.add((Component)customPanel, "Center");
        }
        this.setAnchor((JComponent)this.myUseProxy);
        this.loginAnonymouslyChanged(!this.myLoginAnonymouslyJBCheckBox.isSelected());
    }

    protected final void updateCustomPanel() {
        this.myCustomPanel.removeAll();
        JComponent customPanel = this.createCustomPanel();
        if (customPanel != null) {
            this.myCustomPanel.add((Component)customPanel, "Center");
        }
        this.myCustomPanel.repaint();
    }

    private void loginAnonymouslyChanged(boolean enabled) {
        this.myUsernameLabel.setEnabled(enabled);
        this.myUserNameText.setEnabled(enabled);
        this.myPasswordLabel.setEnabled(enabled);
        this.myPasswordText.setEnabled(enabled);
        this.myUseHttpAuthenticationCheckBox.setEnabled(enabled);
    }

    @Nullable
    protected JComponent createCustomPanel() {
        return null;
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
    }

    protected void enableButtons() {
        this.myUseProxy.setEnabled(HttpConfigurable.getInstance().USE_HTTP_PROXY);
        if (!HttpConfigurable.getInstance().USE_HTTP_PROXY) {
            this.myUseProxy.setSelected(false);
        }
    }

    protected void installListener(JCheckBox checkBox) {
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRepositoryEditor.this.doApply();
            }
        });
    }

    protected void installListener(JTextField textField) {
        textField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BaseRepositoryEditor.this.doApply();
                    }
                });
            }
        });
    }

    protected void installListener(JComboBox comboBox) {
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BaseRepositoryEditor.this.doApply();
                }
            }
        });
    }

    protected void installListener(Document document) {
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                BaseRepositoryEditor.this.doApply();
            }
        });
    }

    protected void installListener(EditorTextField editor) {
        this.installListener(editor.getDocument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doApply() {
        if (!this.myApplying) {
            try {
                this.myApplying = true;
                this.apply();
            }
            finally {
                this.myApplying = false;
            }
        }
    }

    @Override
    public JComponent createComponent() {
        return this.myPanel;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myURLText;
    }

    @Override
    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    public void apply() {
        ((TaskRepository)this.myRepository).setUrl(this.myURLText.getText().trim());
        ((BaseRepository)this.myRepository).setUsername(this.myUserNameText.getText().trim());
        ((BaseRepository)this.myRepository).setPassword(this.myPasswordText.getText());
        ((TaskRepository)this.myRepository).setShared(this.myShareUrlCheckBox.isSelected());
        ((BaseRepository)this.myRepository).setUseProxy(this.myUseProxy.isSelected());
        ((BaseRepository)this.myRepository).setUseHttpAuthentication(this.myUseHttpAuthenticationCheckBox.isSelected());
        ((BaseRepository)this.myRepository).setLoginAnonymously(this.myLoginAnonymouslyJBCheckBox.isSelected());
        ((TaskRepository)this.myRepository).setShouldFormatCommitMessage(this.myAddCommitMessage.isSelected());
        ((TaskRepository)this.myRepository).setCommitMessageFormat(this.myDocument.getText());
        this.myChangeListener.consume(this.myRepository);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myUrlLabel.setAnchor(anchor);
        this.myUsernameLabel.setAnchor(anchor);
        this.myPasswordLabel.setAnchor(anchor);
        this.myUseProxy.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JTextPane jTextPane;
        JPasswordField jPasswordField;
        JBLabel jBLabel2;
        JTextField jTextField;
        JBLabel jBLabel3;
        JBCheckBox jBCheckBox2;
        JCheckBox jCheckBox;
        JButton jButton;
        JCheckBox jCheckBox2;
        JButton jButton2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        JTextField jTextField2;
        JBLabel jBLabel4;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel3.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("General", null, jPanel4, null);
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUrlLabel = jBLabel4 = new JBLabel();
        jBLabel4.setHorizontalAlignment(4);
        jBLabel4.setText("Server URL:");
        jBLabel4.setDisplayedMnemonic('R');
        jBLabel4.setDisplayedMnemonicIndex(8);
        jPanel4.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myURLText = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCustomPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(5, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myUseProxy = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setHorizontalAlignment(4);
        jBCheckBox3.setText("Use proxy");
        jBCheckBox3.setMnemonic('Y');
        jBCheckBox3.setDisplayedMnemonicIndex(8);
        jPanel4.add((Component)jBCheckBox3, new GridConstraints(6, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myProxySettingsButton = jButton2 = new JButton();
        jButton2.setText("Proxy settings...");
        jButton2.setMnemonic('O');
        jButton2.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jButton2, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUseHttpAuthenticationCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Use HTTP authentication");
        jCheckBox2.setMnemonic('H');
        jCheckBox2.setDisplayedMnemonicIndex(4);
        jPanel4.add((Component)jCheckBox2, new GridConstraints(6, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setText("Test");
        jButton.setMnemonic('S');
        jButton.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jButton, new GridConstraints(7, 3, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myShareUrlCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Share URL");
        jCheckBox.setMnemonic('A');
        jCheckBox.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLoginAnonymouslyJBCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Login Anonymously");
        jBCheckBox2.setMnemonic('G');
        jBCheckBox2.setDisplayedMnemonicIndex(2);
        jPanel4.add((Component)jBCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameLabel = jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalAlignment(4);
        jBLabel3.setText("Username:");
        jBLabel3.setDisplayedMnemonic('M');
        jBLabel3.setDisplayedMnemonicIndex(6);
        jPanel4.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUserNameText = jTextField = new JTextField();
        jTextField.setToolTipText("Use DOMAIN\\Login format for NTLM authentication");
        jPanel4.add((Component)jTextField, new GridConstraints(3, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordLabel = jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(4);
        jBLabel2.setText("Password:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPasswordText = jPasswordField = new JPasswordField();
        jPanel4.add((Component)jPasswordField, new GridConstraints(4, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAdvertiser = jTextPane = new JTextPane();
        jTextPane.setText("Not YouTrack customer yet? Get YouTrack");
        ((Component)jTextPane).setEnabled(true);
        jTextPane.setEditable(false);
        jPanel4.add((Component)jTextPane, new GridConstraints(0, 2, 1, 2, 4, 0, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Commit Message", null, jPanel5, null);
        this.myComment = jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("Use...");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel5.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddCommitMessage = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Add commit message");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel4.setLabelFor(jTextField2);
        jBLabel3.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

