/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiEquivalenceUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.PsiEquivalenceUtil");

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, boolean areCommentsSignificant) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, resolvedElementsComparator, null, null, areCommentsSignificant);
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, @Nullable Comparator<PsiElement> leafElementsComparator, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        PsiElement[] children2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element1 == element2) {
            return true;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren(element1, isElementSignificantCondition, areCommentsSignificant);
        if (children1.length != (children2 = PsiEquivalenceUtil.getFilteredChildren(element2, isElementSignificantCondition, areCommentsSignificant)).length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (PsiEquivalenceUtil.areElementsEquivalent(child1, child2, resolvedElementsComparator, leafElementsComparator, isElementSignificantCondition, areCommentsSignificant)) continue;
            return false;
        }
        if (children1.length == 0 && (leafElementsComparator != null ? leafElementsComparator.compare(element1, element2) != 0 : !element1.textMatches(element2))) {
            return false;
        }
        PsiReference ref1 = element1.getReference();
        if (ref1 != null) {
            PsiElement resolved2;
            PsiReference ref2 = element2.getReference();
            if (ref2 == null) {
                return false;
            }
            PsiElement resolved1 = ref1.resolve();
            if (!(Comparing.equal((Object)resolved1, (Object)(resolved2 = ref2.resolve())) || resolvedElementsComparator != null && resolvedElementsComparator.compare(resolved1, resolved2) == 0)) {
                return false;
            }
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, null, false);
    }

    public static PsiElement[] getFilteredChildren(@NotNull PsiElement element, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/PsiEquivalenceUtil", "getFilteredChildren"));
        }
        ASTNode[] children1 = element.getNode().getChildren(null);
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode node : children1) {
            PsiElement child = node.getPsi();
            if (child instanceof PsiWhiteSpace || !areCommentsSignificant && child instanceof PsiComment || isElementSignificantCondition != null && !isElementSignificantCondition.value((Object)child)) continue;
            array.add(child);
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public static void findChildRangeDuplicates(PsiElement first, PsiElement last, final List<Couple<PsiElement>> result, PsiElement scope) {
        PsiEquivalenceUtil.findChildRangeDuplicates(first, last, scope, new PairConsumer<PsiElement, PsiElement>(){

            public void consume(PsiElement start, PsiElement end) {
                result.add(Couple.of((Object)start, (Object)end));
            }
        });
    }

    public static void findChildRangeDuplicates(PsiElement first, PsiElement last, PsiElement scope, PairConsumer<PsiElement, PsiElement> consumer) {
        LOG.assertTrue(first.getParent() == last.getParent());
        LOG.assertTrue(!(first instanceof PsiWhiteSpace) && !(last instanceof PsiWhiteSpace));
        PsiEquivalenceUtil.addRangeDuplicates(scope, first, last, consumer);
    }

    private static void addRangeDuplicates(PsiElement scope, PsiElement first, PsiElement last, PairConsumer<PsiElement, PsiElement> result) {
        PsiElement[] children = PsiEquivalenceUtil.getFilteredChildren(scope, null, true);
        int i = 0;
        block0: while (i < children.length) {
            PsiElement child = children[i];
            if (child != first) {
                int j = i;
                PsiElement next = first;
                while (PsiEquivalenceUtil.areElementsEquivalent(children[j], next)) {
                    ++j;
                    if (next == last) {
                        result.consume((Object)child, (Object)children[j - 1]);
                        i = j + 1;
                        continue block0;
                    }
                    next = PsiTreeUtil.skipSiblingsForward(next, PsiWhiteSpace.class);
                }
                if (i == j) {
                    PsiEquivalenceUtil.addRangeDuplicates(child, first, last, result);
                }
            }
            ++i;
        }
    }
}

