/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class LocatableConfigurationBase
extends RunConfigurationBase
implements LocatableConfiguration {
    private static final String ATTR_NAME_IS_GENERATED = "nameIsGenerated";
    private boolean myNameIsGenerated;

    protected LocatableConfigurationBase(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    public boolean isGeneratedName() {
        return this.suggestedName() != null && this.myNameIsGenerated;
    }

    public void setGeneratedName() {
        this.setName(this.suggestedName());
        this.myNameIsGenerated = true;
    }

    @Override
    public String suggestedName() {
        return null;
    }

    public void setNameChangedByUser(boolean nameChangedByUser) {
        this.myNameIsGenerated = !nameChangedByUser;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myNameIsGenerated = "true".equals(element.getAttributeValue(ATTR_NAME_IS_GENERATED));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myNameIsGenerated && this.suggestedName() != null) {
            element.setAttribute(ATTR_NAME_IS_GENERATED, "true");
        }
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    @Nullable
    public String getActionName() {
        String name = this.getName();
        return name.length() < 20 ? name : name.substring(0, 20) + "...";
    }
}

