/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.platform.ProjectTemplate;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardContext
extends UserDataHolderBase {
    @Nullable
    private final Project myProject;
    private String myProjectFileDirectory;
    private String myProjectName;
    private String myCompilerOutputDirectory;
    private Sdk myProjectJdk;
    private ProjectBuilder myProjectBuilder;
    private ProjectTemplate myProjectTemplate;
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private StorageScheme myProjectStorageFormat = StorageScheme.DIRECTORY_BASED;
    private boolean myNewWizard;
    private ModulesProvider myModulesProvider;

    public void setProjectStorageFormat(StorageScheme format) {
        this.myProjectStorageFormat = format;
    }

    public boolean isNewWizard() {
        return this.myNewWizard;
    }

    public void setNewWizard(boolean newWizard) {
        this.myNewWizard = newWizard;
    }

    public ModulesProvider getModulesProvider() {
        return this.myModulesProvider;
    }

    public void setModulesProvider(ModulesProvider modulesProvider) {
        this.myModulesProvider = modulesProvider;
    }

    public WizardContext(@Nullable Project project) {
        this.myProject = project;
        if (this.myProject != null) {
            this.myProjectJdk = ProjectRootManager.getInstance(this.myProject).getProjectSdk();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getProjectFileDirectory() {
        if (this.myProjectFileDirectory != null) {
            String string = this.myProjectFileDirectory;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/WizardContext", "getProjectFileDirectory"));
            }
            return string;
        }
        String lastProjectLocation = GeneralSettings.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            String string = lastProjectLocation.replace('/', File.separatorChar);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/WizardContext", "getProjectFileDirectory"));
            }
            return string;
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        String string = userHome.replace('/', File.separatorChar) + File.separator + productName.replace(" ", "") + "Projects";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/WizardContext", "getProjectFileDirectory"));
        }
        return string;
    }

    public boolean isProjectFileDirectorySet() {
        return this.myProjectFileDirectory != null;
    }

    public void setProjectFileDirectory(String projectFileDirectory) {
        this.myProjectFileDirectory = projectFileDirectory;
    }

    public String getCompilerOutputDirectory() {
        return this.myCompilerOutputDirectory;
    }

    public void setCompilerOutputDirectory(String compilerOutputDirectory) {
        this.myCompilerOutputDirectory = compilerOutputDirectory;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public boolean isCreatingNewProject() {
        return this.myProject == null;
    }

    public Icon getStepIcon() {
        return null;
    }

    public void requestWizardButtonsUpdate() {
        for (Listener listener : this.myListeners) {
            listener.buttonsUpdateRequested();
        }
    }

    public void requestNextStep() {
        for (Listener listener : this.myListeners) {
            listener.nextStepRequested();
        }
    }

    public void addContextListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeContextListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    public void setProjectJdk(Sdk jdk) {
        this.myProjectJdk = jdk;
    }

    public Sdk getProjectJdk() {
        return this.myProjectJdk;
    }

    @Nullable
    public ProjectBuilder getProjectBuilder() {
        return this.myProjectBuilder;
    }

    public void setProjectBuilder(@Nullable ProjectBuilder projectBuilder) {
        this.myProjectBuilder = projectBuilder;
    }

    @Nullable
    public ProjectTemplate getProjectTemplate() {
        return this.myProjectTemplate;
    }

    public void setProjectTemplate(ProjectTemplate projectTemplate) {
        this.myProjectTemplate = projectTemplate;
        this.setProjectBuilder(projectTemplate.createModuleBuilder());
    }

    public String getPresentationName() {
        return this.myProject == null ? IdeBundle.message("project.new.wizard.project.identification", new Object[0]) : IdeBundle.message("project.new.wizard.module.identification", new Object[0]);
    }

    public StorageScheme getProjectStorageFormat() {
        return this.myProjectStorageFormat;
    }

    public static interface Listener {
        public void buttonsUpdateRequested();

        public void nextStepRequested();
    }
}

