/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class XmlFilePattern<Self extends XmlFilePattern<Self>>
extends PsiFilePattern<XmlFile, Self> {
    public XmlFilePattern() {
        super(XmlFile.class);
    }

    protected XmlFilePattern(@NotNull InitialPatternCondition<XmlFile> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/XmlFilePattern", "<init>"));
        }
        super(condition);
    }

    public Self withRootTag(final ElementPattern<XmlTag> rootTag) {
        return (Self)((XmlFilePattern)this.with(new PatternCondition<XmlFile>("withRootTag"){

            @Override
            public boolean accepts(@NotNull XmlFile xmlFile, ProcessingContext context) {
                if (xmlFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/patterns/XmlFilePattern$1", "accepts"));
                }
                XmlDocument document = xmlFile.getDocument();
                return document != null && rootTag.getCondition().accepts(document.getRootTag(), context);
            }
        }));
    }

    public static class Capture
    extends XmlFilePattern<Capture> {
    }
}

