/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.FontUtil;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class JavaFoldingBuilder
extends JavaFoldingBuilderBase {
    @Override
    protected boolean isBelowRightMargin(Project project, int lineLength) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        return lineLength <= settings.getRightMargin((Language)JavaLanguage.INSTANCE);
    }

    @Override
    protected boolean shouldShowExplicitLambdaType(PsiAnonymousClass anonymousClass, PsiNewExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiAssignmentExpression) {
            return true;
        }
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expression, false);
        return types.length != 1 || !types[0].getType().equals(anonymousClass.getBaseClassType());
    }

    @Override
    @NotNull
    protected String rightArrow() {
        String string = JavaFoldingBuilder.getRightArrow();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilder", "rightArrow"));
        }
        return string;
    }

    @NotNull
    public static String getRightArrow() {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        String string = FontUtil.rightArrow((Font)font);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilder", "getRightArrow"));
        }
        return string;
    }
}

